% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/btb_add_centroids.R
\name{btb_add_centroids}
\alias{btb_add_centroids}
\title{Link points to their centroids}
\usage{
btb_add_centroids(
  pts,
  iCellSize,
  offset = c(0L, 0L),
  names_coords = c("x", "y"),
  names_centro = c("x_centro", "y_centro"),
  add = TRUE
)
}
\arguments{
\item{pts}{: points (\code{df} of \code{sf} object)}

\item{iCellSize}{:
\itemize{
\item Size of the square cells (\strong{meters})
\item Taille des côtés des carreaux (\strong{mètres})
}}

\item{offset}{(\strong{numeric vector of size 2})
\itemize{
\item Offset for a grid non centered on the geographical referential origin
\item Décalage si utilisation d'une grille non centrée sur l'origine du référentiel géographique
}}

\item{names_coords}{:
\itemize{
\item Names of the latitude-longitude variables (\strong{character vector})
\item Noms des variables de latitude-longitude (\strong{vecteur character})
}}

\item{names_centro}{\itemize{
\item Names of the latitude-longitude variables for added centroids  (\strong{character vector})
\itemize{
\item Noms des variables de latitude-longitude pour les centroïdes ajoutés (\strong{vecteur character})
}
}}

\item{add}{(\strong{boolean})
\itemize{
\item If TRUE : returns pts + centroids coordinates
\item Si TRUE : retourne pts + les coordonnées des centroïdes
}}
}
\value{
\itemize{
\item \code{pts} table with additional centroids coordinates \code{x_centro} and \code{y_centro} (\code{df} of \code{sf} object)
\item Table \code{pts} avec les coordonnées des centroïdes \code{x_centro} and \code{y_centro} (objet \code{df} of \code{sf} )
}
}
\description{
\itemize{
\item Link some points to their centroids in a grid segmentation
\item Relie des points aux centroides des carreaux auxquels ces points appartiennent (dans un découpage de l'espace en grille carroyée)
}
}
\details{
Works with sf points but only with coordinates in meters (and not degrees !). Do not use sf points with GPS coordinates for example.
}
\examples{
pts <- data.frame(
x = c(656913.1 , 348296.3 , 842276.3 , 716750.0 , 667418.2),
y = c(6855995 , 6788073 , 6385680 , 7003984 , 6585793),
val = 1:5)
btb_add_centroids(pts, 100, names_centro = c("centroX", "centroY"))
btb_add_centroids(pts, 100, offset = c(50, 50), names_centro = c("centroX", "centroY"))
pts2 <- sf::st_as_sf(pts, coords = c("x","y"), crs = 2154)
btb_add_centroids(pts2, 50)
}
