% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast.R
\name{forecast.PosteriorBSVARSIGN}
\alias{forecast.PosteriorBSVARSIGN}
\title{Forecasting using Structural Vector Autoregression}
\usage{
\method{forecast}{PosteriorBSVARSIGN}(
  posterior,
  horizon = 1,
  exogenous_forecast = NULL,
  conditional_forecast = NULL
)
}
\arguments{
\item{posterior}{posterior estimation outcome - an object of class 
\code{PosteriorBSVARSIGN} obtained by running the \code{estimate} function.}

\item{horizon}{a positive integer, specifying the forecasting horizon.}

\item{exogenous_forecast}{a matrix of dimension \code{horizon x d} containing 
forecasted values of the exogenous variables.}

\item{conditional_forecast}{a \code{horizon x N} matrix with forecasted values 
for selected variables. It should only contain \code{numeric} or \code{NA} 
values. The entries with \code{NA} values correspond to the values that are 
forecasted conditionally on the realisations provided as \code{numeric} values.}
}
\value{
A list of class \code{Forecasts} containing the
draws from the predictive density and data. The output list includes element:

\describe{
 \item{forecasts}{an \code{NxhorizonxS} array with the draws from predictive density}
 \item{Y}{an \eqn{NxT} matrix with the data on dependent variables}
}
}
\description{
Samples from the joint predictive density of all of the dependent 
variables for models from packages \pkg{bsvars}, \pkg{bsvarSIGNs} or 
\pkg{bvarPANELs} at forecast horizons from 1 to \code{horizon} specified as 
an argument of the function. Also facilitates forecasting using models with 
exogenous variables and conditional forecasting given projected future 
trajcetories of (some of the) variables.
}
\examples{
# upload data
data(optimism)

# specify the model and set seed
set.seed(123)

# + no effect on productivity (zero restriction)
# + positive effect on stock prices (positive sign restriction) 
sign_irf       = matrix(c(0, 1, rep(NA, 23)), 5, 5)
specification  = specify_bsvarSIGN$new(optimism, sign_irf = sign_irf)

# estimate the model
posterior      = estimate(specification, 10)

# sample from predictive density 1 year ahead
predictive     = forecast(posterior, 4)

# workflow with the pipe |>
############################################################
set.seed(123)
optimism |>
  specify_bsvarSIGN$new(sign_irf = sign_irf) |>
  estimate(S = 20) |> 
  forecast(horizon = 4) -> predictive

# conditional forecasting 2 quarters ahead conditioning on 
#  provided future values for the Gross Domestic Product 
############################################################
cf         = matrix(NA , 2, 5)
# # conditional forecasts equal to the last consumption observation
cf[,3]     = tail(optimism, 1)[3]
predictive = forecast(posterior, 2, conditional_forecast = cf)

# workflow with the pipe |>
############################################################
set.seed(123)
optimism |>
  specify_bsvarSIGN$new(sign_irf = sign_irf) |>
  estimate(S = 10) |> 
  forecast(horizon = 2, conditional_forecast = cf) -> predictive

}
\seealso{
\code{\link{estimate.BSVARSIGN}}, \code{\link{summary}}, \code{\link{plot}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me} and Xiaolei Wang \email{adamwang15@gmail.com}
}
