% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_smoother.R
\name{sim_smoother}
\alias{sim_smoother}
\alias{sim_smoother.gaussian}
\alias{sim_smoother.nongaussian}
\title{Simulation Smoothing}
\usage{
sim_smoother(model, nsim, seed, use_antithetic = TRUE, ...)

\method{sim_smoother}{gaussian}(
  model,
  nsim = 1,
  seed = sample(.Machine$integer.max, size = 1),
  use_antithetic = TRUE,
  ...
)

\method{sim_smoother}{nongaussian}(
  model,
  nsim = 1,
  seed = sample(.Machine$integer.max, size = 1),
  use_antithetic = TRUE,
  ...
)
}
\arguments{
\item{model}{Model of class \code{bsm_lg}, \code{ar1_lg}
\code{ssm_ulg}, or \code{ssm_mlg}, or one of the non-gaussian models
\code{bsm_ng}, \code{ar1_ng} \code{svm}, 
\code{ssm_ung}, or \code{ssm_mng}.}

\item{nsim}{Number of samples (positive integer).}

\item{seed}{Seed for the random number generator (positive integer).}

\item{use_antithetic}{Logical. If \code{TRUE} (default), use antithetic 
variable for location in simulation smoothing. Ignored for \code{ssm_mng} 
models.}

\item{...}{Ignored.}
}
\value{
An array containing the generated samples.
}
\description{
Function \code{sim_smoother} performs simulation smoothing i.e. simulates 
the states from the conditional distribution \eqn{p(\alpha | y, \theta)} 
for linear-Gaussian models.
}
\details{
For non-Gaussian/non-linear models, the simulation is based on the 
approximating Gaussian model.
}
\examples{
# only missing data, simulates from prior
model <- bsm_lg(rep(NA, 25), sd_level = 1, 
  sd_y = 1)
# use antithetic variable for location
sim <- sim_smoother(model, nsim = 4, use_antithetic = TRUE, seed = 1)
ts.plot(sim[, 1, ])
cor(sim[, 1, ])
}
