% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{ssm_mlg}
\alias{ssm_mlg}
\title{General multivariate linear Gaussian state space models}
\usage{
ssm_mlg(
  y,
  Z,
  H,
  T,
  R,
  a1,
  P1,
  init_theta = numeric(0),
  D,
  C,
  state_names,
  update_fn = default_update_fn,
  prior_fn = default_prior_fn
)
}
\arguments{
\item{y}{Observations as multivariate time series or matrix with dimensions n x p.}

\item{Z}{System matrix Z of the observation equation as p x m matrix or p x m x n array.}

\item{H}{Lower triangular matrix H of the observation. Either a scalar or a vector of length n.}

\item{T}{System matrix T of the state equation. Either a m x m matrix or a
m x m x n array. UPDATE!!}

\item{R}{Lower triangular matrix R the state equation. Either a m x k matrix or a
m x k x n array.}

\item{a1}{Prior mean for the initial state as a vector of length m.}

\item{P1}{Prior covariance matrix for the initial state as m x m matrix.}

\item{init_theta}{Initial values for the unknown hyperparameters theta.}

\item{D}{Intercept terms for observation equation, given as a p x n matrix.}

\item{C}{Intercept terms for state equation, given as m x n matrix.}

\item{state_names}{Names for the states.}

\item{update_fn}{Function which returns list of updated model 
components given input vector theta. This function should take only one 
vector argument which is used to create list with elements named as
\code{Z}, \code{H} \code{T}, \code{R}, \code{a1}, \code{P1}, \code{D}, and \code{C},
where each element matches the dimensions of the original model.
If any of these components is missing, it is assumed to be constant wrt. theta.}

\item{prior_fn}{Function which returns log of prior density 
given input vector theta.}
}
\value{
Object of class \code{ssm_mlg}.
}
\description{
Constructs an object of class \code{ssm_mlg} by defining the corresponding terms
of the observation and state equation:
}
\details{
\deqn{y_t = D(t,\theta) + Z(t,\theta)  \alpha_t + H(t, \theta) \epsilon_t, (\textrm{observation equation})}
\deqn{\alpha_{t+1} = C(t,\theta) + T(t, \theta) \alpha_t + R(t, \theta)\eta_t, (\textrm{transition equation})}

where \eqn{\epsilon_t \sim N(0, I_p)}, \eqn{\eta_t \sim N(0, I_m)} and
\eqn{\alpha_1 \sim N(a_1, P_1)} independently of each other.
}
