% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bscui.R
\name{bscuiProxy}
\alias{bscuiProxy}
\alias{bscui_Proxy}
\title{Manipulate an existing bscui instance in a 'shiny' app}
\usage{
bscuiProxy(shinyId, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{shinyId}{single-element character vector indicating the 'shiny' output
ID of the UI to modify}

\item{session}{the 'shiny' session object to which the UI belongs; usually
the default value will suffice}
}
\value{
A \code{bscui_Proxy} object with an "id" and a "session" slot.
}
\description{
Manipulate an existing bscui instance in a 'shiny' app
}
\details{
This function creates a proxy object that can be used to manipulate an
existing bscui instance in a 'shiny' app using different methods:
\itemize{
\item \link{update_bscui_ui_elements}: change type and title of elements
\item \link{update_bscui_styles}: set style of UI elements
\item \link{update_bscui_attributes} set attributes of a UI element
\item \link{update_bscui_selection}: chose selected elements
\item \link{click_bscui_element}: trigger a single or double click on a UI element
\item \link{order_bscui_elements}: change elements order (e.g. move them forward)
\item \link{add_bscui_element}: add an SVG element to the UI
\item \link{remove_bscui_elements}: remove SVG elements from the UI
\item \link{get_bscui_svg}: get the displayed SVG in R session
}
}
\examples{
if(interactive()){
   from_shiny <- new.env()
   shiny::runApp(system.file(
      "examples", "shiny-anatomogram", package = "bscui"
   ))
   for(n in names(from_shiny)){
      bscui(from_shiny[[n]]) |> print()
   }
}
}
\seealso{
\link{bscui-shiny}
}
