% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bs_accordion}
\alias{bs_accordion}
\title{Create a Bootstrap accordion}
\usage{
bs_accordion(
  id,
  items = list(),
  accordion_class = "accordion",
  item_class = "accordion-item",
  item_header_class = "accordion-header",
  button_class = "accordion-button",
  div_class = "accordion-collapse collapse",
  body_class = "accordion-body"
)
}
\arguments{
\item{id}{A string, the id to use for the accordion, must be unique within a page (if you have multiple accordions on a page).}

\item{items}{A named list, names become the label for each panel, values should be the HTML content to display
when the panel is toggled.}

\item{accordion_class}{A string, the class of the div wrapping the accordion content.}

\item{item_class}{A string, the class of the div wrapping the accordion items.}

\item{item_header_class}{A string, the class of the accordion panel headers.}

\item{button_class}{A string, the class of the div wrapping the accordion panel header button items.}

\item{div_class}{A string, the class of the div wrapping the accordion panel content.}

\item{body_class}{A string, the class of the div wrapping the accordion panel content body.}
}
\value{
A string of HTML.
}
\description{
Create a Bootstrap accordion
}
\examples{
bs_accordion(
id = "acc1",
items = list(
  "One" = p("Check it out."),
  "Two" = p("Does it work?"),
  "Three" = p("I hope so.")
)
)
}
