% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update-functions.R, R/aliases.R
\name{updatebs4TabItems}
\alias{updatebs4TabItems}
\alias{updateTabItems}
\title{Change the selected sidebar tab on the client}
\usage{
updatebs4TabItems(session, inputId, selected = NULL)

updateTabItems(session, inputId, selected = NULL)
}
\arguments{
\item{session}{shiny session.}

\item{inputId}{\link{bs4TabSetPanel} unique id.}

\item{selected}{the tab to be selected.}
}
\description{
This function controls the active tab of \code{\link{bs4TabItems}} from the
server. It behaves just like \code{\link{updatebs4TabSetPanel}}.
}
\examples{
## Only run this example in interactive R sessions
if (interactive()) {
 library(shiny)
 library(bs4Dash)
 
 shinyApp(
   ui = bs4DashPage(
     sidebar_collapsed = FALSE,
     controlbar_collapsed = TRUE,
     enable_preloader = FALSE,
     navbar = bs4DashNavbar(skin = "dark"),
     body = bs4DashBody(
       bs4TabItems(
         bs4TabItem(
           tabName = "tab1",
           sliderInput("obs", "Number of observations:",
                       min = 0, max = 1000, value = 500
           ),
           plotOutput("distPlot")
         ),
         bs4TabItem(
           tabName = "tab2",
           checkboxGroupInput("variable", "Variables to show:",
                              c("Cylinders" = "cyl",
                                "Transmission" = "am",
                                "Gears" = "gear")),
           tableOutput("data")
         ),
         bs4TabItem(
           tabName = "tab3",
           checkboxInput("val", "Some value", FALSE),
           textOutput("value")
         )
       )
     ),
     sidebar = bs4DashSidebar(
       skin = "light",
       bs4SidebarMenu(
         id = "sidebar",
         bs4SidebarMenuItem(
           text = "Tab 1",
           tabName = "tab1",
           icon = "card"
         ),
         bs4SidebarMenuItem(
           text = "Tab 2",
           tabName = "tab2",
           icon = "card"
         ),
         bs4SidebarMenuItem(
           text = "Tab 3",
           tabName = "tab3",
           icon = "card"
         )
       )
     ),
     controlbar = bs4DashControlbar(
       skin = "light",
       sliderInput(
         inputId = "controller",
         label = "Update the first tabset",
         min = 1,
         max = 3,
         value = 2
       )
     ),
     footer = bs4DashFooter()
   ),
   server = function(input, output, session) {
     
     # update tabset1
     observeEvent(input$controller, {
       updatebs4TabSetPanel(
         session, 
         inputId = "sidebar", 
         selected = input$controller
       )
     })
     
     output$distPlot <- renderPlot({
       hist(rnorm(input$obs))
     })
     
     output$data <- renderTable({
       mtcars[, c("mpg", input$variable), drop = FALSE]
     }, rownames = TRUE)
     
     output$value <- renderText({ input$val })
     
   }
 )
}
}
