% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cards.R
\name{bs4ValueBox}
\alias{bs4ValueBox}
\title{Boostrap 4 value box}
\usage{
bs4ValueBox(value, subtitle, icon = NULL, elevation = NULL,
  status = NULL, width = 3, href = NULL)
}
\arguments{
\item{value}{The value to display in the box. Usually a number or short text.}

\item{subtitle}{Subtitle text.}

\item{icon}{An icon tag, created by \code{\link[shiny]{icon}}.}

\item{elevation}{Value box elevation.}

\item{status}{A color for the box. "primary", "info", "success", "warning", "danger" or NULL.}

\item{width}{The width of the box, using the Bootstrap grid system. This is
used for row-based layouts. The overall width of a region is 12, so the
default width of 4 occupies 1/3 of that width. For column-based
layouts, use \code{NULL} for the width; the width is set by the column that
contains the box.}

\item{href}{An optional URL to link to.}
}
\description{
A beautiful AdminLTE3 value box.
}
\examples{
if(interactive()){
 library(shiny)
 library(bs4Dash)
 
 shiny::shinyApp(
   ui = bs4DashPage(
     navbar = bs4DashNavbar(),
     sidebar = bs4DashSidebar(),
     controlbar = bs4DashControlbar(),
     footer = bs4DashFooter(),
     title = "test",
     body = bs4DashBody(
      fluidRow(
       bs4ValueBox(
        value = 150,
        subtitle = "New orders",
        status = "primary",
        icon = "shopping-cart",
        href = "#"
       ),
       bs4ValueBox(
        value = "53\%",
        subtitle = "New orders",
        status = "danger",
        icon = "cogs"
       ),
       bs4ValueBox(
        value = "44",
        subtitle = "User Registrations",
        status = "warning",
        icon = "sliders"
       )
      )
     )
   ),
   server = function(input, output) {}
 )
}

}
\seealso{
Other cards: \code{\link{bs4Card}},
  \code{\link{bs4InfoBox}}, \code{\link{bs4TabCard}}
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
\concept{cards}
