% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cards.R
\name{bs4InfoBox}
\alias{bs4InfoBox}
\title{Boostrap 4 info box}
\usage{
bs4InfoBox(..., title, value = NULL, icon = NULL, iconElevation = 3,
  status = NULL, gradientColor = NULL, width = 4, elevation = NULL)
}
\arguments{
\item{...}{Any extra UI element.}

\item{title}{Info box title.}

\item{value}{The value to display in the box. Usually a number or short text.}

\item{icon}{An icon tag, created by \code{\link[shiny]{icon}}.}

\item{iconElevation}{Icon elevation compared to the main content (relief). 3 by default.}

\item{status}{A color for the box. "primary", "info", "success", "warning", "danger" or NULL.}

\item{gradientColor}{If NULL (the default), the background of the box will be
white. Otherwise, a color string. "primary", "success", "warning" or "danger".}

\item{width}{The width of the box, using the Bootstrap grid system. This is
used for row-based layouts. The overall width of a region is 12, so the
default width of 4 occupies 1/3 of that width. For column-based
layouts, use \code{NULL} for the width; the width is set by the column that
contains the box.}

\item{elevation}{Infobox elevation.}
}
\description{
A beautiful AdminLTE3 info box.
}
\examples{
if(interactive()){
 library(shiny)
 library(bs4Dash)
 
 shiny::shinyApp(
   ui = bs4DashPage(
     navbar = bs4DashNavbar(),
     sidebar = bs4DashSidebar(),
     controlbar = bs4DashControlbar(),
     footer = bs4DashFooter(),
     title = "test",
     body = bs4DashBody(
      fluidRow(
       bs4InfoBox(
        title = "Messages",
        value = 1410,
        icon = "envelope"
       ),
       bs4InfoBox(
        title = "Bookmarks",
        status = "info",
        value = 240,
        icon = "bookmark"
       ),
       bs4InfoBox(
        title = "Comments",
        gradientColor = "danger",
        value = 41410,
        icon = "comments"
       )
      )
     )
   ),
   server = function(input, output) {}
 )
}

}
\seealso{
Other cards: \code{\link{bs4Card}},
  \code{\link{bs4TabCard}}, \code{\link{bs4ValueBox}}
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
\concept{cards}
