% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/distributions.R
\name{BNBDist}
\alias{BNBDist}
\alias{dbeta_nbinom}
\alias{pbeta_nbinom}
\alias{qbeta_nbinom}
\alias{rbeta_nbinom}
\alias{sbeta_nbinom}
\alias{summary_beta_nbinom}
\title{Beta-negative binomial distribution}
\usage{
dbeta_nbinom(x, a, c, d, ...)

pbeta_nbinom(q, a, c, d, ...)

qbeta_nbinom(p, a, c, d, ...)

rbeta_nbinom(n, a, c, d)

sbeta_nbinom(a, c, d)

summary_beta_nbinom(a, c, d, output = "list", ...)
}
\arguments{
\item{x,q}{vector of non-negative integer quantities}

\item{a,c,d}{non-negative shape parameters}

\item{...}{other arguments passed to \code{\link[SuppDists]{ghyper}}}

\item{p}{vector of probabilities}

\item{n}{number of observations to be sampled}

\item{output}{type of the \code{summary_beta_nbinom} output: \code{"list"} to return a list, \code{"pandoc"} to print a table}
}
\value{
\code{dbeta_nbinom} gives the density,
\code{pbeta_nbinom} the cumulative function,
\code{qbeta_nbinom} the quantile function,
\code{rbeta_nbinom} samples from the distribution,
\code{sbeta_nbinom} and \code{summary_beta_nbinom} give some summaries of the distribution.
}
\description{
Density, cumulative function, quantile function and random generation
for the  Beta-negative binomial distribution
with shape parameters \code{a}, \code{c}, \code{d}.










}
\details{
This is the mixture distribution obtained by sampling a value \eqn{b}
from a Beta distribution with parameters \eqn{c}, \eqn{d},
then sampling a value \eqn{\lambda} from a Gamma distribution with
shape \eqn{a} and rate \eqn{b/(1-b)}, and
then sampling a Poisson distribution with mean \eqn{\lambda}.
}
\note{
\code{BNBDist} is a generic name for the functions documented.
}
\examples{
a <- 2 ; c <- 5 ; d <- 30
barplot(dbeta_nbinom(0:50, a, c, d), names=0:50)
summary_beta_nbinom(a, c, d)
}

