% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics_easystats.R
\name{glance_performance}
\alias{glance_performance}
\title{glance_performance}
\usage{
glance_performance(x, ...)
}
\arguments{
\item{x}{model or other R object to convert to single-row data frame}

\item{...}{other arguments passed to methods}
}
\value{
A data frame (with one row) and one column per "index".
}
\description{
Computes indices of model performance for regression models.
}
\details{
The function will attempt to get these details either using
\code{broom::glance} or \code{performance::model_performance}.
}
\examples{
set.seed(123)
mod <- lm(mpg ~ wt + cyl, data = mtcars)
glance_performance(mod, conf.int = TRUE)
}
