% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mfx-tidiers.R
\name{tidy.mfx}
\alias{tidy.mfx}
\alias{tidy.logitmfx}
\alias{tidy.negbinmfx}
\alias{tidy.poissonmfx}
\alias{tidy.probitmfx}
\title{Tidy a(n) mfx object}
\usage{
\method{tidy}{mfx}(x, conf.int = FALSE, conf.level = 0.95, ...)

\method{tidy}{logitmfx}(x, conf.int = FALSE, conf.level = 0.95, ...)

\method{tidy}{negbinmfx}(x, conf.int = FALSE, conf.level = 0.95, ...)

\method{tidy}{poissonmfx}(x, conf.int = FALSE, conf.level = 0.95, ...)

\method{tidy}{probitmfx}(x, conf.int = FALSE, conf.level = 0.95, ...)
}
\arguments{
\item{x}{A \code{logitmfx}, \code{negbinmfx}, \code{poissonmfx}, or \code{probitmfx}  object.
(Note that \code{betamfx} objects receive their own set of tidiers.)}

\item{conf.int}{Logical indicating whether or not to include a confidence
interval in the tidied output. Defaults to \code{FALSE}.}

\item{conf.level}{The confidence level to use for the confidence interval
if \code{conf.int = TRUE}. Must be strictly greater than 0 and less than 1.
Defaults to 0.95, which corresponds to a 95 percent confidence interval.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.

The particular functions below provide generic tidy methods for
objects returned by the \code{mfx} package, preserving the calculated marginal
effects instead of the naive model coefficients. The returned tidy tibble
will also include an additional "atmean" column indicating how the marginal
effects were originally calculated (see Details below).
}
\details{
The \code{mfx} package provides methods for calculating marginal effects
for various generalized linear models (GLMs). Unlike standard linear
models, estimated model coefficients in a GLM cannot be directly
interpreted as marginal effects (i.e., the change in the response variable
predicted after a one unit change in one of the regressors). This is
because the estimated coefficients are multiplicative, dependent on both
the link function that was used for the estimation and any other variables
that were included in the model. When calculating marginal effects, users
must typically choose whether they want to use i) the average observation
in the data, or ii) the average of the sample marginal effects. See
\code{vignette("mfxarticle")} from the \code{mfx} package for more details.
}
\examples{


# feel free to ignore the following line—it allows {broom} to supply 
# examples without requiring the model-supplying package to be installed.
if (requireNamespace("mfx", quietly = TRUE)) {

# load libraries for models and data
library(mfx)

# get the marginal effects from a logit regression
mod_logmfx <- logitmfx(am ~ cyl + hp + wt, atmean = TRUE, data = mtcars)

tidy(mod_logmfx, conf.int = TRUE)

# compare with the naive model coefficients of the same logit call
tidy(
  glm(am ~ cyl + hp + wt, family = binomial, data = mtcars), conf.int = TRUE
)

augment(mod_logmfx)
glance(mod_logmfx)

# another example, this time using probit regression
mod_probmfx <- probitmfx(am ~ cyl + hp + wt, atmean = TRUE, data = mtcars)

tidy(mod_probmfx, conf.int = TRUE)
augment(mod_probmfx)
glance(mod_probmfx)

}

}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[mfx:logitmfx]{mfx::logitmfx()}}, \code{\link[mfx:negbinmfx]{mfx::negbinmfx()}}, \code{\link[mfx:poissonmfx]{mfx::poissonmfx()}}, \code{\link[mfx:probitmfx]{mfx::probitmfx()}}

Other mfx tidiers: 
\code{\link{augment.betamfx}()},
\code{\link{augment.mfx}()},
\code{\link{glance.betamfx}()},
\code{\link{glance.mfx}()},
\code{\link{tidy.betamfx}()}
}
\concept{mfx tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{conf.high}{Upper bound on the confidence interval for the estimate.}
  \item{conf.low}{Lower bound on the confidence interval for the estimate.}
  \item{estimate}{The estimated value of the regression term.}
  \item{p.value}{The two-sided p-value associated with the observed statistic.}
  \item{statistic}{The value of a T-statistic to use in a hypothesis that the regression term is non-zero.}
  \item{std.error}{The standard error of the regression term.}
  \item{term}{The name of the regression term.}
  \item{atmean}{TRUE if the marginal effects were originally calculated as 
  the partial effects for the average observation. If FALSE, then these 
  were instead calculated as average partial effects.}

}
