% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R, R/loo-helpers.R
\name{kfold.brmsfit}
\alias{kfold.brmsfit}
\alias{kfold}
\title{K-Fold Cross-Validation}
\usage{
\method{kfold}{brmsfit}(x, ..., compare = TRUE, K = 10, Ksub = NULL,
  exact_loo = FALSE, group = NULL, resp = NULL, model_names = NULL,
  save_fits = FALSE)

kfold(x, ...)
}
\arguments{
\item{x}{A fitted model object.}

\item{...}{More fitted model objects or further arguments
passed to the underlying post-processing functions.}

\item{compare}{A flag indicating if the information criteria
of the models should be compared to each other
via \code{\link{compare_ic}}.}

\item{K}{The number of subsets of equal (if possible) size
into which the data will be randomly partitioned for performing
\eqn{K}-fold cross-validation. The model is refit \code{K} times, each time
leaving out one of the \code{K} subsets. If \code{K} is equal to the total
number of observations in the data then \eqn{K}-fold cross-validation is
equivalent to exact leave-one-out cross-validation.}

\item{Ksub}{Optional number of subsets (of those subsets defined by \code{K}) 
to be evaluated. If \code{NULL} (the default), \eqn{K}-fold cross-validation 
will be performed on all subsets. If \code{Ksub} is a single integer, 
\code{Ksub} subsets (out of all \code{K}) subsets will be randomly chosen.
If \code{Ksub} consists of multiple integers or a one-dimensional array
(created via \code{as.array}) potentially of length one, the corresponding 
subsets will be used. This argument is primarily useful, if evaluation of 
all subsets is infeasible for some reason.}

\item{exact_loo}{Logical; If \code{TRUE}, exact leave-one-out cross-validation
will be performed and \code{K} will be ignored. This argument alters
the way argument \code{group} is handled as described below. 
Defaults to \code{FALSE}.}

\item{group}{Optional name of a grouping variable or factor in the model.
How this variable is handled depends on argument \code{exact_loo}.
If \code{exact_loo} is \code{FALSE}, the data is split 
up into subsets, each time omitting all observations of one of the 
factor levels, while ignoring argument \code{K}. 
If \code{exact_loo} is \code{TRUE}, all observations corresponding 
to the factor level of the currently predicted single value are omitted. 
Thus, in this case, the predicted values are only a subset of the 
omitted ones.}

\item{resp}{Optional names of response variables.
If specified, fitted values of these response variables are returned.}

\item{model_names}{If \code{NULL} (the default) will use model names 
derived from deparsing the call. Otherwise will use the passed 
values as model names.}

\item{save_fits}{If \code{TRUE}, a component \code{fits} is added to 
the returned object to store the cross-validated \code{brmsfit} 
objects and the indices of the omitted observations for each fold. 
Defaults to \code{FALSE}.}
}
\value{
\code{kfold} returns an object that has a similar structure as the 
  objects returned by the \code{loo} and \code{waic} methods.
}
\description{
Perform exact K-fold cross-validation by refitting the model \eqn{K}
times each leaving out one-\eqn{K}th of the original data.
}
\details{
The \code{kfold} function performs exact \eqn{K}-fold
  cross-validation. First the data are randomly partitioned into \eqn{K}
  subsets of equal (or as close to equal as possible) size. Then the model is
  refit \eqn{K} times, each time leaving out one of the \code{K} subsets. If
  \eqn{K} is equal to the total number of observations in the data then
  \eqn{K}-fold cross-validation is equivalent to exact leave-one-out
  cross-validation (to which \code{loo} is an efficient approximation). The
  \code{compare_ic} function is also compatible with the objects returned
  by \code{kfold}.
}
\section{Methods (by class)}{
\itemize{
\item \code{brmsfit}: \code{kfold} method for \code{brmsfit} objects
}}

\examples{
\dontrun{
fit1 <- brm(count ~ log_Age_c + log_Base4_c * Trt + 
              (1|patient) + (1|obs),
           data = epilepsy, family = poisson())
# throws warning about some pareto k estimates being too high
(loo1 <- loo(fit1))
# perform 10-fold cross validation
(kfold1 <- kfold(fit1, chains = 2, cores = 2)
}   
 
}
\seealso{
\code{\link{loo}}, \code{\link{reloo}}
}
