% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior.R
\name{draws-brms}
\alias{draws-brms}
\alias{as_draws}
\alias{as_draws_matrix}
\alias{as_draws_array}
\alias{as_draws_df}
\alias{as_draws_rvars}
\alias{as_draws_list}
\alias{as_draws.brmsfit}
\alias{as_draws_matrix.brmsfit}
\alias{as_draws_array.brmsfit}
\alias{as_draws_df.brmsfit}
\alias{as_draws_list.brmsfit}
\alias{as_draws_rvars.brmsfit}
\title{Transform \code{brmsfit} to \code{draws} objects}
\usage{
\method{as_draws}{brmsfit}(x, variable = NULL, regex = FALSE, inc_warmup = FALSE, ...)

\method{as_draws_matrix}{brmsfit}(x, variable = NULL, regex = FALSE, inc_warmup = FALSE, ...)

\method{as_draws_array}{brmsfit}(x, variable = NULL, regex = FALSE, inc_warmup = FALSE, ...)

\method{as_draws_df}{brmsfit}(x, variable = NULL, regex = FALSE, inc_warmup = FALSE, ...)

\method{as_draws_list}{brmsfit}(x, variable = NULL, regex = FALSE, inc_warmup = FALSE, ...)

\method{as_draws_rvars}{brmsfit}(x, variable = NULL, regex = FALSE, inc_warmup = FALSE, ...)
}
\arguments{
\item{x}{A \code{brmsfit} object or another \R object for which
the methods are defined.}

\item{variable}{A character vector providing the variables to extract.
By default, all variables are extracted.}

\item{regex}{Logical; Should variable should be treated as a (vector of) 
regular expressions? Any variable in \code{x} matching at least one of the 
regular expressions will be selected. Defaults to \code{FALSE}.}

\item{inc_warmup}{Should warmup draws be included? Defaults to \code{FALSE}.}

\item{...}{Arguments passed to individual methods (if applicable).}
}
\description{
Transform a \code{brmsfit} object to a format supported by the 
\pkg{posterior} package.
}
\details{
To subset iterations, chains, or draws, use the
  \code{\link[posterior:subset_draws]{subset_draws}} method after
  transforming the \code{brmsfit} to a \code{draws} object.
}
\examples{
\dontrun{
fit <- brm(count ~ zAge + zBase * Trt + (1|patient),
           data = epilepsy, family = poisson())
           
# extract posterior draws in an array format
(draws_fit <- as_draws_array(fit))
posterior::summarize_draws(draws_fit)

# extract only certain variables
as_draws_array(fit, variable = "r_patient")
as_draws_array(fit, variable = "^b_", regex = TRUE)

# extract posterior draws in a random variables format
as_draws_rvars(fit)
}

}
\seealso{
\code{\link[posterior:draws]{draws}}
  \code{\link[posterior:subset_draws]{subset_draws}}
}
