% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/families.R
\name{brmsfamily}
\alias{acat}
\alias{bernoulli}
\alias{brmsfamily}
\alias{categorical}
\alias{cauchy}
\alias{cratio}
\alias{cumulative}
\alias{exponential}
\alias{geometric}
\alias{hurdle_gamma}
\alias{hurdle_negbinomial}
\alias{hurdle_poisson}
\alias{negbinomial}
\alias{sratio}
\alias{student}
\alias{weibull}
\alias{zero_inflated_negbinomial}
\alias{zero_inflated_poisson}
\title{Special Family Functions for \pkg{brms} Models}
\usage{
student(link = "identity")

cauchy(link = "identity")

bernoulli(link = "logit")

negbinomial(link = "log")

geometric(link = "log")

exponential(link = "log")

weibull(link = "log")

hurdle_poisson(link = "log")

hurdle_negbinomial(link = "log")

hurdle_gamma(link = "log")

zero_inflated_poisson(link = "log")

zero_inflated_negbinomial(link = "log")

categorical(link = "logit")

cumulative(link = "logit")

sratio(link = "logit")

cratio(link = "logit")

acat(link = "logit")
}
\arguments{
\item{link}{A specification for the model link function. 
This can be a name/expression or character string. 
The following list only refers to \pkg{brms} specific family functions.
Families \code{student}, and \code{cauchy} accept the links (as names) 
\code{identity}, \code{log}, and \code{inverse};
families \code{negbinomial}, and \code{geometric} the links 
\code{log}, \code{identity}, and \code{sqrt}; 
families \code{bernoulli}, \code{cumulative}, \code{cratio}, \code{sratio}, 
and \code{acat} the links \code{logit}, \code{probit}, \code{probit_approx}, 
\code{cloglog}, and \code{cauchit};
family \code{categorical} the link \code{logit}; families \code{weibull}, 
and \code{exponential} the links \code{log}, \code{identity}, and \code{inverse};
families \code{hurdle_poisson}, \code{hurdle_gamma}, 
\code{hurdle_negbinomial}, \code{zero_inflated_poisson}, 
and \code{zero_inflated_negbinomial} the link \code{log}.  
The first link mentioned for each family is the default.
A full list of families and link functions supported by \pkg{brms}, 
is provided in the 'Details' section of \code{\link[brms:brm]{brm}}.}
}
\description{
Family objects provide a convenient way to specify the details of the models 
used by many model fitting functions. The families present here are currently 
for use with \pkg{brms} only and will NOT work with other model fitting functions such as 
\code{glm} or \code{glmer}. However, the standard family functions as decribed in
\code{\link[stats:family]{family}} will work with \pkg{brms}. For a full list 
of families and link functions supported by \pkg{brms}, see the documentation
(in particular the 'Details' section) of \code{\link[brms:brm]{brm}}.
}

