% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/validate.R
\name{set_prior}
\alias{set_prior}
\title{Prior Deinitions for \pkg{brms} Models}
\usage{
set_prior(prior, class = "b", coef = "", group = "")
}
\arguments{
\item{prior}{A character string defining a distribution in \pkg{Stan} language}

\item{class}{The parameter class. Defaults to \code{"b"} (fixed effects).
See 'Details' for other valid parameter classes.}

\item{coef}{Name of the (fixed, category specific, or random effects) parameter}

\item{group}{Grouping factor for random effects parameters.}
}
\value{
An object of class \code{brmsprior} to be used in the \code{prior}
  argument of \code{\link[brms:brm]{brm}}.
}
\description{
Define priors for specific parameters or classes of parameters
}
\details{
\code{set_prior} is used to define prior distributions for parameters in \pkg{brms} models.
  Below, we explain its usage and list some common prior distributions for parameters.
  A complete overview on possible prior distributions is given in the Stan Reference Manual available at
  \url{http://mc-stan.org/}.

  To combine multiple priors, use \code{c(...)}, e.g., \code{c(set_prior(...), set_prior(...))}.
  \pkg{brms} performs no checks if the priors are written in correct Stan language.
  Instead, Stan will check their correctness when the model is parsed to C++ and returns an error if they are not.
  Currently, there are five types of parameters in \pkg{brms} models,
  for which the user can specify prior distributions. \cr

  1. Fixed and category specific effects

  Every fixed (and category specific) effect has its corresponding regression parameter. These parameters are internally named as
  \code{b_<fixed>}, where \code{<fixed>} represents the name of the corresponding fixed effect.
  Suppose, for instance, that \code{y} is predicted by \code{x1} and \code{x2}
  (i.e. \code{y ~ x1+x2} in formula syntax).
  Then, \code{x1} and \code{x2} have regression parameters \code{b_x1} and \code{b_x2} respectively.
  The default prior for fixed and category specific effects is an improper flat prior over the reals.
  Other common options are normal priors or uniform priors over a finite interval.
  If we want to have a normal prior with mean 0 and standard deviation 5 for \code{x1},
  and a uniform prior between -10 and 10 for \code{x2}, we can specify this via
  \code{set_prior("normal(0,5)", class = "b", coef = "x1")} and \cr
  \code{set_prior("uniform(-10,10)", class = "b", coef = "x2")}.
  To put the same prior on all fixed effects at once,
  we may write as a shortcut \code{set_prior("<prior>", class = "b")}. This also
  leads to faster sampling, because priors can be vectorized in this case. \cr

  2. Autocorrelation parameters

  The autocorrelation parameters currently implemented are named \code{ar} (autoregression) and \code{ma} (moving average).
  The default prior for autocorrelation parameters is an improper flat prior over the reals.
  Other priors can be defined with \code{set_prior("<prior>", class = "ar")}
  or \cr \code{set_prior("<prior>", class = "ma")}. It should be noted that \code{ar} will
  only take one values between -1 and 1 if the response variable is wide-sence stationay,
  i.e. if there is no drift in the responses. \cr

  3. Standard deviations of random effects

  Each random effect of each grouping factor has a standard deviation named
  \code{sd_<group>_<random>}. Consider, for instance, the formula \code{y ~ x1+x2+(1+x1|g)}.
  We see that the intercept as well as \code{x1} are random effects nested in the grouping factor \code{g}.
  The corresponding standard deviation parameters are named as \code{sd_g_Intercept} and \code{sd_g_x1} respectively.
  These parameters are restriced to be non-negative and, by default,
  have a half cauchy prior with scale parameter 5.
  We could make this explicit by writing \code{set_prior("cauchy(0,5)", class = "sd")}.
  To define a prior distribution only for standard deviations of a specific grouping factor,
  use \cr \code{set_prior("<prior>", class = "sd", group = "<group>")}.
  To define a prior distribution only for a specific standard deviation
  of a specific grouping factor, you may write \cr
  \code{set_prior("<prior>", class = "sd", group = "<group>", coef = "<coef>")}.
  Recommendations on useful prior distributions for standard deviations are given in Gelman (2006). \cr

  4. Correlations of random effects

  If there is more than one random effect per grouping factor, the correlations between those random
  effects have to be estimated.
  The prior \code{"lkj_corr_cholesky(eta)"} or in short \code{"lkj(eta)"} with \code{eta > 0} is essentially the only prior
  for (choelsky factors) of correlation matrices. If \code{eta = 1} (the default) all correlations matrices
  are equally likely a priori. If \code{eta > 1}, extreme correlations become less likely,
  whereas \code{0 < eta < 1} results in higher probabilities for extreme correlations.
  Correlation matrix parameters in \code{brms} models are named as
  \code{cor_(group)}, (e.g., \code{cor_g} if \code{g} is the grouping factor).
  To set the same prior on every correlation matrix, use for instance \code{set_prior("lkj(2)", class = "cor")}.

  5. Parameters for specific families

  Some families need additional parameters to be estimated.
  Families \code{gaussian}, \code{student}, and \code{cauchy} need the parameter \code{sigma}
  to account for the standard deviation of the response variable around the regression line
  (not to be confused with the standard deviations of random effects).
  By default, \code{sigma} has a half cauchy prior with 'mean' 0 and 'standard deviation' 5.
  Furthermore, family \code{student} needs the parameter \code{nu} representing
  the degrees of freedom of students t distribution.
  By default, \code{nu} has prior \code{"uniform(1,100)"}.
  Families \code{gamma} and \code{weibull} need the parameter \code{shape}
  that has a \code{"gamma(0.01,0.01)"} prior by default. For families \code{cumulative}, \code{cratio}, \code{sratio},
  and \code{acat}, and only if \code{threshold = "equidistant"}, the parameter \code{delta} is used to model the distance
  between to adjacent thresholds. By default, \code{delta} has an improper flat prior over the reals. \cr
  Every family specific parameter has its own prior class, so that \cr
  \code{set_prior("<prior>", class = "<parameter>")} it the right way to go.

  Often, it may not be immediately clear, which parameters are present in the model.
  To get a full list of parameters and parameter classes for which priors can be specified (depending on the model)
  use function \code{\link[brms:get_prior]{get_prior}}.
}
\examples{
\dontrun{
## check which parameters can have priors
get_prior(rating ~ treat + period + carry + (1|subject),
          data = inhaler, family = "cumulative",
          threshold = "equidistant")

## define some priors
prior <- c(set_prior("normal(0,10)", class = "b"),
           set_prior("normal(1,2)", class = "b", coef = "treat"),
           set_prior("cauchy(0,2)", class = "sd",
                     group = "subject", coef = "Intercept"),
           set_prior("uniform(-5,5)", class = "delta"))

## use the defined priors in the model
fit <- brm(rating ~ period + carry + (1|subject),
           data = inhaler, family = "sratio",
           partial = ~ treat, threshold = "equidistant",
           prior = prior, n.iter = 1000, n.cluster = 2)

## check that the priors found their way into Stan's model code
fit$model
}
}
\references{
Gelman A (2006). Prior distributions for variance parameters in hierarchical models."
   Bayesian analysis, 1(3), 515 -- 534.
}
\seealso{
\code{\link[brms:get_prior]{get_prior}}
}

