% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/s3.methods.R
\name{plot.brmsfit}
\alias{plot.brmsfit}
\title{Trace and density plots for MCMC samples}
\usage{
\method{plot}{brmsfit}(x, parameters = NA, combine = FALSE, N = 5,
  ask = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{brmsfit}.}

\item{parameters}{Name of the parameters to plot, as given by a character vector or a regular expression.
By default, all parameters except for random effects and posterior predictives are plotted.}

\item{combine}{logical; Indicates if the samples of all chains should be combined into one posterior distribution.}

\item{N}{The number of parameters plotted per page.}

\item{ask}{logical; Indicates if the user is prompted before a new page is plotted.}

\item{...}{Currently ignored.}
}
\description{
Trace and density plots for MCMC samples using the \code{ggmcmc} package
}
\examples{
\dontrun{
fit_e <- brm(count ~ log_Age_c + log_Base4_c * Trt_c + (1|patient) + (1|visit),
             data = epilepsy, family = "poisson")
## plot fixed effects as well as standard devations and correlations (if present) of random effects
plot(fit_e)
## plot fixed effects only and combine the chains into one posterior
plot(fit_e, parameters = "^b_", combine = TRUE)
}
}
\author{
Paul-Christian Buerkner \email{paul.buerkner@gmail.com}
}

