% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/briskaR.R
\docType{package}
\encoding{UTF-8}
\name{briskaR-package}
\alias{briskaR-package}
\alias{_PACKAGE}
\alias{briskaR}
\title{Biological Risk Assessment}
\description{
A spatio-temporal exposure-hazard model for assessing biological risk and impact.
The model is based on stochastic geometry for describing the landscape and the exposed individuals,
a dispersal kernel for the dissemination of contaminants and an ecotoxicological equation.
}
\details{
The briskaR package contains functions and methods for quantifying spatio-temporal variation in contamination risk
around known polygon sources of contaminants, and quantifies the impact of the contaminants on the surrounding population of individuals
which are located in habitat areas and are susceptible to the contaminants.

The package implements an spatio-temporal exposure-hazard model based on (i) tools of stochastic geometry (marked polygon and point processes)
for structuring the landscape and describing the location of exposed individuals,
(ii) a method based on a dispersal kernel describing the dissemination of contaminant particles from polygon sources,
and (iii) ecotoxicological equations describing how contaminants affect individuals of the exposed population.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://gitlab.paca.inrae.fr/biosp/briskaR}
  \item Report bugs at \url{https://gitlab.paca.inrae.fr/biosp/briskaR/-/issues}
}

}
\author{
Virgile Baudrot \email{virgile.baudrot@posteo.fr}

Emily Walker \email{emily.walker@inrae.fr}

Jean-Francois Rey \email{jean-francois.rey@inrae.fr}

Melen Leclerc \email{melen.leclerc@inrae.fr}

Samuel Soubeyrand \email{Samuel.Soubeyrand@inrae.fr}

Marc Bourotte \email{marc.bourotte@inrae.fr}

Maintainer: Jean-Francois REY \email{jean-francois.rey@inrae.fr}
}
\keyword{model}
\keyword{spatial}
\keyword{survival}
