% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brglmFit.R
\name{brglmFit}
\alias{brglmFit}
\title{Fitting function for \code{\link{glm}} for reduced-bias
estimation and inference}
\usage{
brglmFit(x, y, weights = rep(1, nobs), start = NULL, etastart = NULL,
  mustart = NULL, offset = rep(0, nobs), family = gaussian(),
  control = list(), intercept = TRUE, fixed_totals = NULL)
}
\arguments{
\item{x}{\code{x} is a design matrix of dimension \code{n * p},}

\item{y}{\code{y} is a vector of observations of length \code{n}}

\item{weights}{an optional vector of \sQuote{prior weights} to be used
    in the fitting process.  Should be \code{NULL} or a numeric vector.}

\item{start}{starting values for the parameters in the linear
predictor. If \code{NULL} (default) then the maximum likelihood
estimates are caluclated and used as starting values}

\item{etastart}{applied only when start is not
\code{NULL}. Starting values for the linear predictor to be
passed to \code{\link{glm.fit}} when computing starting values
using maximum likelihood.}

\item{mustart}{applied only when start is not \code{NULL}. Starting
values for the vector of means to be passed to
\code{\link{glm.fit}} when computing starting values using
maximum likelihood.}

\item{offset}{this can be used to specify an \emph{a priori} known
    component to be included in the linear predictor during fitting.
    This should be \code{NULL} or a numeric vector of length equal to
    the number of cases.  One or more \code{\link{offset}} terms can be
    included in the formula instead or as well, and if more than one is
    specified their sum is used.  See \code{\link{model.offset}}.}

\item{family}{a description of the error distribution and link
    function to be used in the model.  For \code{glm} this can be a
    character string naming a family function, a family function or the
    result of a call to a family function.  For \code{glm.fit} only the
    third option is supported.  (See \code{\link{family}} for details of
    family functions.)}

\item{control}{a list of parameters controlling the fitting
process. See \code{\link{brglmControl}} for details.}

\item{intercept}{logical. Should an intercept be included in the
    \emph{null} model?}

\item{fixed_totals}{effective only when \code{family} is
\code{poisson}. Either \code{NULL} (no effect) or a vector that
indicates which counts must be treated as a group. See Details
for more information and \code{\link{brmultinom}}.}

\item{...}{arguments to be used to form the default 'control'
argument if it is not supplied directly.}
}
\description{
\code{\link{brglmFit}} is a fitting function for \code{\link{glm}}
that fits generalized linear models using implicit and explicit
bias reduction methods. Currently supported methods include the
implicit adjusted scores approach in Firth (1993) and Kosmidis \&
Firth (2009), the correction of the asymptotic bias in Cordeiro &
McCullagh (1991), and maximum likelihood.  Estimation is performed
using a quasi Fisher scoring iteration based on the iterative
correction of the asymptotic bias of the Fisher scoring iterates.
}
\details{
Implicit and explicit bias reduction methods are described in
detail in Kosmidis (2014). The quasi (or modified) Fisher scoring
iteration is described in Kosmidis (2010) and is based on the
iterative correction of the asymptotic bias of the Fisher scoring
iterates. A quick description of the quasi Fisher scoring iteration
is also given in one of the vignettes of the *enrichwith* R package
(see,
\url{https://cran.r-project.org/package=enrichwith/vignettes/bias.html}).


The null deviance is evaluated based on the fitted values using the
    method specified by the \code{type} argument (see
    \code{\link{brglmControl}}).

The description of \code{method} argument and the \code{Fitting
functions} section in \code{\link{glm}} gives information on
supplying fitting methods to \code{\link{glm}}.

\code{fixed_totals} can be used to constrain the means of a poisson
model to add up to the corresponding observed counts according to
}
\examples{
## The lizards example from ?brglm::brglm
data("lizards")
# Fit the model using maximum likelihood
lizardsML <- glm(cbind(grahami, opalinus) ~ height + diameter +
                     light + time, family = binomial(logit), data = lizards,
                 method = "glm.fit")
# Now the bias-reduced fit:
lizardsBR <- glm(cbind(grahami, opalinus) ~ height + diameter +
                     light + time, family = binomial(logit), data = lizards,
                 method = "brglmFit")
summary(lizardsML)
summary(lizardsBR)


## Another example from
## King, Gary, James E. Alt, Nancy Elizabeth Burns and Michael Laver
## (1990).  "A Unified Model of Cabinet Dissolution in Parliamentary
## Democracies", _American Journal of Political Science_, **34**, 846-870

\dontrun{
data("coalition", package = "brglm2")
# The maximum likelihood fit with log link
coalitionML <- glm(duration ~ fract + numst2, family = Gamma, data = coalition)
# The bias-reduced fit
coalitionBR <- update(coalitionML, method = "brglmFit")
# The bias-corrected fit
coalitionBC <- update(coalitionML, method = "brglmFit", type = "correction")
}

\dontrun{
## An example with offsets from Venables & Ripley (2002, p.189)
data("anorexia", package = "MASS")

anorexML <- glm(Postwt ~ Prewt + Treat + offset(Prewt),
                family = gaussian, data = anorexia)
anorexBR <- update(anorexML, method = "brglmFit")
anorexBC <- update(anorexML, method = "brglmFit", type = "correction")

## The outputs are identical, because the maximum likelihood
## estimators of the regression parameters are unbiased when family
## is Gaussian, and the bias-reduced estimator of the dispersion is
## the unbiased, by degree of freedom adjustment, estimator of the
## residual variance.
summary(anorexML)
summary(anorexBR)
summary(anorexBC)
}

## endometrial data from Heinze \\& Schemper (2002) (see ?endometrial)
data("endometrial", package = "brglm2")
endometrialML <- glm(HG ~ NV + PI + EH, data = endometrial,
                     family = binomial("probit"))
endometrialBR <- update(endometrialML, method = "brglmFit",
                        type = "AS_mean")
endometrialBC <- update(endometrialML, method = "brglmFit",
                        type = "correction")
summary(endometrialML)
summary(endometrialBC)
summary(endometrialBR)

}
\author{
Ioannis Kosmidis \email{i.kosmidis@ucl.ac.uk}
}
\references{
Cordeiro G. M. & McCullagh, P. (1991). Bias correction in generalized
linear models. *Journal of the Royal Statistical Society. Series B
(Methodological)*, **53**, 629-643

Firth D. (1993). Bias reduction of maximum likelihood estimates,
Biometrika, **80**, 27-38

Kosmidis I and Firth D (2009). Bias reduction in exponential family
nonlinear models. *Biometrika*, **96**, 793-804

Kosmidis I and Firth D (2010). A generic algorithm for reducing
bias in parametric estimation. *Electronic Journal of Statistics*,
**4**, 1097-1112

Kosmidis I (2014). Bias in parametric estimation: reduction and
useful side-effects. *WIRE Computational Statistics*, **6**,
185-196
}
\seealso{
\code{\link{glm.fit}} and \code{\link{glm}}
}

