% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_unemployment.R
\name{get_unemployment}
\alias{get_unemployment}
\title{Retrieve Brazil's quarterly unemployment rate}
\usage{
get_unemployment(start_year, end_year, language = "eng")
}
\arguments{
\item{start_year}{Starting year (e.g., 2015)}

\item{end_year}{Ending year (e.g., 2024)}

\item{language}{Language of labels: "eng" (default) or "pt"}
}
\value{
A tibble with columns: \code{date} and \code{rate}
}
\description{
Downloads and cleans data from IBGE's Continuous PNAD via SIDRA API.
}
\examples{
\dontrun{
data <- get_unemployment(2018, 2024, language = "pt")
}
}
