% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thresholding.R
\name{model.thresh}
\alias{model.thresh}
\title{Estimating change-points in the piecewise-constant mean of a noisy data sequence via thresholding}
\usage{
model.thresh(
  cptpath.object,
  sigma = stats::mad(diff(cptpath.object$x)/sqrt(2)),
  th_const = 1.15
)
}
\arguments{
\item{cptpath.object}{A solution-path object, returned by a \code{sol.[name]} routine. Note that the field \code{sols.object$x} contains the input data sequence.}

\item{sigma}{An estimate of the standard deviation of the noise in the data \code{cptpath.object$x}. Can be a functional of \code{cptpath.object$x} or a specific value if known. The default is the Median Absolute Deviation of the vector \code{diff(cptpath.object$x)/sqrt(2)}, tuned to the Gaussian distribution. Note that \code{model.thresh} works particularly well when the noise is i.i.d. Gaussian.}

\item{th_const}{A positive real number with default value equal to 1. It is used to define the threshold for the detection process.}
}
\value{
An S3 object of class \code{cptmodel}, which contains the following fields: 
\item{solution.path}{The solution path method used to obtain \code{cptpath.object}}
\item{model}{The model selection method used to return the final change-point estimators object, here its value is \code{"thresh"}}
\item{no.of.cpt}{The number of estimated change-points in the piecewise-constant mean of the vector \code{cptpath.object$x}}
\item{cpts}{The locations of estimated change-points in the piecewise-constant mean of the vector \code{cptpath.object$x}. These are the end-points of the corresponding constant-mean intervals}
\item{est}{An estimate of the piecewise-constant mean of the vector \code{cptpath.object$x}; the values are the sample means of the data (replicated a suitable number of times) between each pair of consecutive detected change-points}
}
\description{
This function estimates the number and locations of change-points in the piecewise-constant mean of a noisy data sequence via thresholding.
}
\examples{
f <- rep(rep(c(0, 1), each = 50), 10)
x <- f + rnorm(length(f))
model.thresh(sol.idetect_seq(x))
}
\seealso{
\code{\link{sol.idetect_seq}}, \code{\link{sol.idetect_seq}}, \code{\link{sol.not}}, \code{\link{sol.tguh}}, \code{\link{sol.wbs}}, \code{\link{sol.wbs2}}, \code{\link{breakfast}}
}
