% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.broken}
\alias{plot.broken}
\title{Break Down Plot}
\usage{
\method{plot}{broken}(x, trans = I, ..., top_features = 0, min_delta = 0,
  add_contributions = TRUE, vcolors = c(`-1` = "#d8b365", `0` = "#f5f5f5",
  `1` = "#5ab4ac", X = "darkgrey"), digits = 3, rounding_function = round,
  plot_distributions = FALSE)
}
\arguments{
\item{x}{the model model of 'broken' class}

\item{trans}{transformation that shal be applied to scores}

\item{...}{other parameters}

\item{top_features}{maximal number of variables from model we want to plot}

\item{min_delta}{minimal stroke value of variables from model we want to plot}

\item{add_contributions}{shall variable contributions to be added on plot?}

\item{vcolors}{named vector with colors}

\item{digits}{number of decimal places (round) or significant digits (signif) to be used.
See the \code{rounding_function} argument}

\item{rounding_function}{function that is to used for rounding numbers.
It may be \code{signif()} which keeps a specified number of significant digits.
Or the default \code{round()} to have the same precision for all components}

\item{plot_distributions}{if TRUE then distributions of conditional propotions will be plotted. This requires keep_distributions=TRUE in the broken.default().}
}
\value{
a ggplot2 object
}
\description{
Break Down Plot
}
\examples{
\dontrun{
library("breakDown")
library("randomForest")
library("ggplot2")
set.seed(1313)
model <- randomForest(factor(left)~., data = HR_data, family = "binomial", maxnodes = 5)
predict.function <- function(model, new_observation)
      predict(model, new_observation, type="prob")[,2]
predict.function(model, HR_data[11,-7])
explain_1 <- broken(model, HR_data[11,-7], data = HR_data[,-7],
predict.function = predict.function, direction = "down")
explain_1
plot(explain_1) + ggtitle("breakDown plot (direction=down) for randomForest model")

explain_2 <- broken(model, HR_data[11,-7], data = HR_data[,-7],
predict.function = predict.function, direction = "down", keep_distributions = TRUE)
plot(explain_2, plot_distributions = TRUE) +
         ggtitle("breakDown distributions (direction=down) for randomForest model")

explain_3 <- broken(model, HR_data[11,-7], data = HR_data[,-7],
predict.function = predict.function, direction = "up", keep_distributions = TRUE)
plot(explain_3, plot_distributions = TRUE) +
         ggtitle("breakDown distributions (direction=up) for randomForest model")

model <- lm(quality~., data=wine)
new_observation <- wine[1,]
br <- broken(model, new_observation)
plot(br)
plot(br, top_features = 2)
plot(br, top_features = 2, min_delta = 0.01)
}
}
