% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dip_class_plot.R
\name{dip_class_plot}
\alias{dip_class_plot}
\title{Plot of Dipping Classifications}
\usage{
dip_class_plot(
  data,
  subj = NULL,
  dip_thresh = 0.1,
  extreme_thresh = 0.2,
  thresh_mult = 2,
  sleep_start_end = NULL
)
}
\arguments{
\item{data}{User-supplied data set that must contain \code{SBP}, \code{DBP}, and either \code{DATE_TIME} or \code{WAKE}
columns in order to distinguish between sleep and awake

In the event of non-ABPM data (i.e. a data set without a corresponding \code{WAKE} column), then a
\code{DATE_TIME} column \strong{must} be present in order to denote which times correspond to sleep and which
times correspond to awake.}

\item{subj}{Optional argument. Allows the user to specify and subset specific subjects
from the \code{ID} column of the supplied data set. The \code{subj} argument can be a single
value or a vector of elements. The input type should be character, but the function will
comply with integers so long as they are all present in the \code{ID} column of the data.}

\item{dip_thresh}{Default threshold for normal "Dipping" set to 0.10 (i.e. 10\%). This value represents the maximum
percentage that BP can fall during sleep and be characterized as "Normal" nocturnal decline (dipping).
Specifically, this category includes all dips between 0\% and this value.}

\item{extreme_thresh}{Default threshold for "Extreme Dipping" set to 0.20 (i.e. 20\%). This value represents the maximum
percentage that BP can fall during sleep and be characterized as "Extreme" nocturnal decline (dipping).
Specifically, this category includes all dips between the Normal dipping threshold and this value.

NOTE: dip_thresh cannot exceed extreme_thresh.}

\item{thresh_mult}{Optional argument that serves as a multiplier by which to expand plot sizing for X and Y axis. Default
set to 2.}

\item{sleep_start_end}{Optional User-supplied manual override to adjust sleep interval indicating indicate start and end time
corresponding to the sleep interval of interest. Must only contain 2 values and must be 24-hour denoted integers

Example: \code{sleep_start_end = c(22,5)} indicates a sleep period from 10pm - 5am.}
}
\value{
A scatter plot of all dipping percentage values layered on top of the category plot outlined in
Okhubo et al. (1995). dip_thresh and extreme_thresh denote the cutoffs for the Normal and Extreme
dipping categories. Any dips below zero are denoted as Inverted (or Reverse) dipping.

The default plot categories are as follows:
\itemize{
   \item{\emph{INV}: Inverted (Reverse) Dipper - no nocturnal decline (greater or equal to 0\%)}
   \item{\emph{ND}: Non-Dipper - a nocturnal decline between 0 - 10\%}
   \item{\emph{DIP}: Dipper - a nocturnal decline between 10\% and the extreme dipping \% (20\%)}
   \item{\emph{ED}: Extreme Dipper - a nocturnal decline exceeding 20\%}
}
}
\description{
Plot of Dipping Classifications
}
\examples{
hypnos_proc <- process_data(bp::bp_hypnos,
                               sbp = "syst",
                               dbp = "DIAST",
                               date_time = "date.time",
                               id = "id",
                               wake = "wake",
                               visit = "visit")

dip_class_plot(hypnos_proc)
}
\references{
Okhubo, T., Imai, Y., Tsuji, K., Nagai, K., Watanabe, N., Minami, J., Kato, J., Kikuchi, N., Nishiyama, A.,
Aihara, A., Sekino, M., Satoh, H., and Hisamichi, S. (1997). Relation Between Nocturnal Decline in Blood
Pressure and Mortality: The Ohasama Study,
\emph{American Journal of Hypertension} \strong{10(11)}, 1201--1207,
\doi{10.1016/S0895-7061(97)00274-4}.
}
