% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec.r
\name{spec}
\alias{spec}
\alias{parse_spec}
\alias{mod_spec}
\alias{pkg_spec}
\alias{spec_name}
\title{Parse a mod or pkg spec expression passed to \code{use}}
\usage{
parse_spec(expr, alias)

mod_spec(spec, ...)

pkg_spec(spec, ...)

spec_name(spec)
}
\arguments{
\item{expr}{the mod or pkg spec expression to parse}

\item{alias}{the mod or pkg spec alias as a character, or \code{NULL}}

\item{spec}{named list of information the parser constructed from a given
spec expression}

\item{...}{further information about a spec, not represented by the spec
expression parse tree}
}
\value{
\code{parse_spec} returns a named list that contains information
about the parsed mod specification. Currently it contains:
\describe{
 \item{\code{name}}{the module or package name}
 \item{\code{prefix}}{the prefix, if the spec is a module}
 \item{\code{attach}}{a named vector of symbols to attach, or
     \code{TRUE} to attach all symbols, or \code{NULL} to attach nothing}
 \item{\code{alias}}{the module or package alias}
 \item{\code{explicit}}{a logical value indicating whether the caller
     provided an explicit alias}
}
}
\description{
Parse a mod or pkg spec expression passed to \code{use}
}
\keyword{internal}
