% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deck_funcs.R
\name{deal_card}
\alias{deal_card}
\title{Deal a Card from the Deck}
\usage{
deal_card(current_deck)
}
\arguments{
\item{current_deck}{A dataframe representing the current deck of cards.}
}
\value{
A list containing two elements:
\itemize{
\item \code{dealt_card}: A dataframe containing the dealt card.
\item \code{updated_deck}: A dataframe representing the updated deck after dealing.
}
}
\description{
This function deals the top card from a given deck and updates the deck by
removing the dealt card. If the deck is empty, the function will return an
error indicating there are no more cards to deal.
}
\examples{
# Create a sample deck
deck <- data.frame(card = c("A", "B", "C"), value = c(1, 2, 3))

# Deal a card from the sample deck
result <- deal_card(deck)
dealt <- result$dealt_card
remaining <- result$updated_deck

}
