% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kselect_ref.R
\name{k.select_ref}
\alias{k.select_ref}
\title{Estimate number of clusters}
\usage{
k.select_ref(df, k_range = 2:7, n_ref = 5, B = 100, B_ref = 50, r = 5)
}
\arguments{
\item{df}{\code{data.frame} of the input dataset}

\item{k_range}{\code{integer} valued \code{vector} of the numbers of clusters k to be tested upon}

\item{n_ref}{number of reference distribution to be generated}

\item{B}{number of bootstrap re-samples}

\item{B_ref}{number of bootstrap resamples for the reference distributions}

\item{r}{number of runs of k-means}
}
\value{
\describe{
\item{\code{profile}}{\code{vector} of ( Smin_diff(k) - ( Smin_diff(k+1) + sd(Smin_diff(k+1)) ) ) measures for researchers's inspection}
\item{\code{k}}{estimated number of clusters}
}
}
\description{
Estimate number of clusters by bootstrapping stability
}
\details{
This function uses the out-of-bag scheme to estimate the number of clusters
in a dataset. The function calculate the Smin of the dataset and at the same time, generate
a reference dataset with the same range as the original dataset in each dimension and calculate
the Smin_ref. The differences between Smin and Smin_ref at each k,Smin_diff(k), is taken into consideration as well as the 
standard deviation of the differences. We choose the k to be the argmax of ( Smin_diff(k) - ( Smin_diff(k+1) + sd(Smin_diff(k+1)) ) ).
If Smin_diff(k) less than 0.1 for all k in k_range, we say k = 1
}
\examples{
\donttest{
set.seed(1)
data(iris)
df <- data.frame(iris[,1:4])
df <- scale(df)
k.select_ref(df, k_range = 2:7, n_ref = 5, B=500, B_ref = 500, r=5)
}
}
\references{
Bootstrapping estimates of stability for clusters, observations and model selection.
Han Yu, Brian Chapman, Arianna DiFlorio, Ellen Eischen, David Gotz, Matthews Jacob and Rachael Hageman Blair.
}
\author{
Tianmou Liu
}
