% Generated by roxygen2 (4.0.0): do not edit by hand
\name{arcx4Reweighter}
\alias{arcx4Reweighter}
\title{Reweighter for the arc-x4 algorithm.}
\usage{
arcx4Reweighter(prediction, response, weights, m, ...)
}
\arguments{
\item{prediction}{a vector of predictions.}

\item{response}{a vector whose \eqn{i^{th}}{ith} component is the true
response for the \eqn{i^{th}}{ith} component of \code{prediction}.}

\item{weights}{a vector of weights. They don't necessarily need to sum to 1.}

\item{...}{implemented to allow reweighter to accept its output as its input.}

\item{m}{a vector length equal to \code{nrow(data)} enumerating each time the
\eqn{i^{th}}{ith} entry in \code{data} has been misclassified by all the estimators
previously built.}
}
\value{
For internal bookkeeping, this function is inherits from the
'\code{reweighter}' class. It returns a named list with components
\item{weights}{the updated weights calculated from the input weights,
\code{prediction} and \code{response}.}

\item{m}{the updated count of misclassifications.}
}
\description{
An implementation of the reweighter described in the arc-x4
algorithm.
}
\note{
If you're going to use this reweighter with \code{\link{boost}} you'll want
to initialize \code{m} to 0 by including \code{.reweighterArgs=list(m=0)} inside
your \code{metadata} list.
}
\seealso{
Other reweighters: \code{\link{adaboostReweighter}};
  \code{\link{arcfsReweighter}}; \code{\link{boost}},
  \code{\link{boost.function}}, \code{\link{boost.list}};
  \code{\link{vanillaBagger}}
}

