% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSeries.R
\name{get_daily}
\alias{get_daily}
\title{Get quality-checked timeseries data}
\usage{
get_daily(
  parameter_type,
  station_number,
  start_date,
  end_date,
  var,
  aggregation,
  tz,
  return_fields
)
}
\arguments{
\item{parameter_type}{The water data parameter type (e.g. Water Course
Discharge). See \code{\link{parameters()}} for a full list.}

\item{station_number}{The AWRC station number.}

\item{start_date}{Start date formatted as a string or date class
(YYYY-MM-DD).}

\item{end_date}{End date formatted as a string or date class (YYYY-MM-DD).}

\item{var}{The daily variable of interest. Valid inputs are `mean`, `min`,
`max` for continuous series such as discharge and `total` for discrete
series such as rainfall and evaporation.}

\item{aggregation}{Whether the data is to be aggregated midnight to
midnight (`24HR`) or from 9am-9am (`09HR`). The default is `24HR`. `09HR`
is only available for mean discharge and total rainfall and evaporation.}

\item{tz}{Optional: the desired time zone for the output timeseries. Input
must be an Olson Name (see \code{OlsonNames()}). By default the the timeseries
is returned in an offset timezone (e.g. \code{Etc/GMT-10} for NSW) as the
timeseries do not observe DST.}

\item{return_fields}{Optional: columns to be returned from Water Data Online.
By default Timestamp, Value and Quality Code are returned.}
}
\value{
A tibble with the requested return fields, which by default are
\code{Timestamp}, \code{Value} and \verb{Quality Code}. Zero row tibbles are returned if
no data is available for the requested dates. The aggregation of data is
generally the mean for most variables, except for rainfall and evaporation
which is the sum over the chosen period.
}
\description{
This function returns a quality-checked timeseries from
Water Data Online.
}
\details{
For the parameters (and their units) that can be requested, see
\link{parameters}. More information can be found in the Water Data Online
SOS manual (URL in See Also below).
}
\examples{
# Download daily mean aggregated over the standard day
get_daily(
  parameter_type = "Water Course Discharge",
  station_number = "410730",
  start_date = "2020-01-01",
  end_date = "2020-01-31",
  var = "mean",
  aggregation = "24HR"
)
# Download daily mean aggregated between 9am to 9am
get_daily(
  parameter_type = "Water Course Discharge",
  station_number = "410730",
  start_date = "2020-01-01",
  end_date = "2020-01-31",
  var = "mean",
  aggregation = "09HR"
)

# Download the daily max over the standard day
get_daily(
  parameter_type = "Water Course Discharge",
  station_number = "410730",
  start_date = "2020-01-01",
  end_date = "2020-01-31",
  var = "max",
  aggregation = "24HR"
)
}
\seealso{
\itemize{
\item \url{http://www.bom.gov.au/waterdata/}
\item \url{http://www.bom.gov.au/waterdata/wiski-web-public/Guide\%20to\%20Sensor\%20Observation\%20Services\%20(SOS2)\%20for\%20Water\%20Data\%20\%20Online\%20v1.0.1.pdf}
}
}
\author{
Alexander Buzacott
}
