% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coanc_to_kinship.R
\name{coanc_to_kinship}
\alias{coanc_to_kinship}
\title{Transform coancestry matrix to kinship matrix}
\usage{
coanc_to_kinship(coancestry)
}
\arguments{
\item{coancestry}{The \code{n}-by-\code{n} coancestry matrix}
}
\value{
The \code{n}-by-\code{n} kinship matrix, preserving column and row names.
}
\description{
If \code{Theta} is the coancestry matrix and \code{Phi} is the kinship matrix (both are \code{n}-by-\code{n} symmetric), then these matrices agree off-diagonal, but the diagonal gets transformed as
\code{diag( Phi ) = ( 1 + diag( Theta ) ) / 2}.
}
\examples{
# a trivial case: unadmixed individuals from independent subpopulations
# number of individuals/subpops
n_ind <- 5
# unadmixed individuals
admix_proportions <- diag(rep.int(1, n_ind))
# equal Fst for all subpops
inbr_subpops <- 0.2
# diagonal coancestry matryx
coancestry <- coanc_admix(admix_proportions, inbr_subpops)
kinship <- coanc_to_kinship(coancestry)

# a more complicated admixture model
# number of individuals
n_ind <- 5
# number of intermediate subpops
k_subpops <- 2
# non-trivial admixture proportions
admix_proportions <- admix_prop_1d_linear(n_ind, k_subpops, sigma = 1)
# different Fst for each of the k subpops
inbr_subpops <- c(0.1, 0.3)
# non-trivial coancestry matrix
coancestry <- coanc_admix(admix_proportions, inbr_subpops)
kinship <- coanc_to_kinship( coancestry )

}
\seealso{
The inverse function is given by \verb{\link[popkin]\{inbr_diag\}}.
}
