% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diameter.R
\name{diameter}
\alias{diameter}
\title{Diameters in a Bayesian network}
\usage{
diameter(bnfit)
}
\arguments{
\item{bnfit}{object of class \code{bn.fit}.}
}
\value{
A dataframe with the following columns: \code{Nodes} - the vertices of the BN; \code{Diameter} - the diameters of the associated conditional probability tables.
}
\description{
Computation of the diameters of all conditional probability tables in a Bayesian network.
}
\details{
The diameter of a conditional probability table \eqn{P} with \eqn{n} rows \eqn{p_1,\dots,p_n} is \deqn{d^+(P)=\max_{i,j\leq n} d_V(p_i,p_j),} where \eqn{d_V} is the total variation distance between two probability mass functions over a sample space \eqn{\mathcal{X}}, i.e. \deqn{d_V(p_i,p_j)=\frac{1}{2}\sum_{x\in\mathcal{X}}|p_i(x)-p_j(x)|.}
}
\examples{
diameter(travel)

}
\references{
Leonelli, M., Smith, J. Q., & Wright, S. K. (2024). The diameter of a stochastic matrix: A new measure for sensitivity analysis in Bayesian networks. arXiv preprint arXiv:2407.04667.
}
