% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svmLP.R
\name{lpSVM}
\alias{lpSVM}
\alias{svmLP}
\alias{predict.svmLP}
\alias{svmMulticlassLP}
\alias{predict.svmMLP}
\title{Linearly Programmed SVM}
\usage{
svmLP(x, y, LAMBDA = 1, loss.weights = 1)

\method{predict}{svmLP}(object, x, ...)

svmMulticlassLP(x, y, LAMBDA = 1, loss.weights = 1)

\method{predict}{svmMLP}(object, x, ...)
}
\arguments{
\item{x}{a numeric data matrix to predict}

\item{y}{a response factor for each row of x. It must be a 2 levels factor for svmLP, or a >=2 levels factor for svmMulticlassLP}

\item{LAMBDA}{control the regularization strength in the optimization process. This is the value used as coefficient of the regularization term.}

\item{loss.weights}{numeric vector of loss weights to incure for each instance of x. 
Vector length should match length(y), but values are cycled if not of identical size.}

\item{object}{an object of class svmLP or svmMLP}

\item{...}{unused, present to satisfy the generic predict() prototype}
}
\value{
the optimized weights matrix, with class svmLP

predict() return predictions for row of x, with an attribute "decision.value"

predict() return predictions for row of x, with an attribute "decision.value"
}
\description{
Linearly Programmed L1-loss Linear Support Vector Machine with L1 regularization
}
\details{
svmLP solves a linear program implementing a linear SVM 
with L1 regularization and L1 loss. It solves:
min_w LAMBDA*|w| + sum_i(e_i);
s.t. y_i * <w.x_i> >= 1-e_i; e_i >= 0
where |w| is the L1-norm of w

svmMulticlassLP solves a linear program implementing multiclass-SVM 
with L1 regularization and L1 loss. It solves:
min_w LAMBDA*|w| + sum_i(e_i);
s.t. <w.x_i> - <w.x_j> >= 1-e_i; e_i >= 0
where |w| is the L1-norm of w
}
\section{Functions}{
\itemize{
\item \code{svmLP}: linear programm solving binary-SVM with L1-regularization and L1-norm

\item \code{svmMulticlassLP}: linear programm solving multiclass-SVM with L1-regularization and L1-norm
}}

\examples{
  x <- cbind(100,data.matrix(iris[1:4]))
  y <- iris$Species
  w <- svmMulticlassLP(x,y)
  table(predict(w,x),y)

  w <- svmLP(x,y=="setosa")
  table(predict(w,x),y)
}
\author{
Julien Prados
}
