% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loss.R
\name{regressionLosses}
\alias{regressionLosses}
\alias{lmsRegressionLoss}
\alias{ladRegressionLoss}
\alias{quantileRegressionLoss}
\alias{epsilonInsensitiveRegressionLoss}
\title{Loss functions to perform a regression}
\usage{
lmsRegressionLoss(x, y, loss.weights = 1)

ladRegressionLoss(x, y, loss.weights = 1)

quantileRegressionLoss(x, y, q = 0.5, loss.weights = 1)

epsilonInsensitiveRegressionLoss(x, y, epsilon, loss.weights = 1)
}
\arguments{
\item{x}{matrix of training instances (one instance by row)}

\item{y}{numeric vector of values representing the training labels for each instance in x}

\item{loss.weights}{numeric vector of loss weights to incure for each instance of x. 
Vector length should match length(y), but values are cycled if not of identical size.}

\item{q}{a numeric value in the range [0-1] defining quantile value to consider}

\item{epsilon}{a numeric value setting tolerance of the epsilon-regression}
}
\value{
a function taking one argument w and computing the loss value and the gradient at point w
}
\description{
Loss functions to perform a regression
}
\section{Functions}{
\itemize{
\item \code{lmsRegressionLoss}: Least Mean Square regression

\item \code{ladRegressionLoss}: Least Absolute Deviation regression

\item \code{quantileRegressionLoss}: Quantile Regression

\item \code{epsilonInsensitiveRegressionLoss}: epsilon-insensitive regression (Vapnik et al. 1997)
}}

\examples{
  x <- cbind(intercept=100,data.matrix(iris[1:2]))
  y <- iris[[3]]
  w <- bmrm(lmsRegressionLoss(x,y))
  w <- bmrm(ladRegressionLoss(x,y))
  w <- bmrm(quantileRegressionLoss(x,y,q=0.5))
  w <- bmrm(epsilonInsensitiveRegressionLoss(x,y,epsilon=1))
}
\references{
Teo et al.
  Bundle Methods for Regularized Risk Minimization
  JMLR 2010
}
\seealso{
bmrm
}
