% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-model-fit-stats.R
\name{blr_rsq_mckelvey_zavoina}
\alias{blr_rsq_mckelvey_zavoina}
\title{McKelvey Zavoina R2}
\usage{
blr_rsq_mckelvey_zavoina(model)
}
\arguments{
\item{model}{An object of class \code{glm}.}
}
\value{
Cragg-Uhler (Nagelkerke) R2 pseudo r-squared.
}
\description{
McKelvey Zavoina pseudo r-squared.
}
\examples{
model <- glm(honcomp ~ female + read + science, data = hsb2,
            family = binomial(link = 'logit'))

blr_rsq_mckelvey_zavoina(model)

}
\references{
McKelvey, R. D., & Zavoina,  W. (1975). A statistical model for the  analysis  of ordinal level dependent 
variables. Journal of Mathematical Sociology, 4, 103-12.
}
\seealso{
Other model fit statistics: \code{\link{blr_model_fit_stats}},
  \code{\link{blr_multi_model_fit_stats}},
  \code{\link{blr_pairs}}, \code{\link{blr_rsq_adj_count}},
  \code{\link{blr_rsq_cox_snell}},
  \code{\link{blr_rsq_effron}},
  \code{\link{blr_rsq_mcfadden_adj}},
  \code{\link{blr_rsq_nagelkerke}},
  \code{\link{blr_test_lr}}
}
\concept{model fit statistics}
