% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blr-stepwise-regression.R
\name{blr_step_p_both}
\alias{blr_step_p_both}
\alias{blr_step_p_both.default}
\alias{plot.blr_step_p_both}
\title{Stepwise regression}
\usage{
blr_step_p_both(model, ...)

\method{blr_step_p_both}{default}(model, pent = 0.1, prem = 0.3,
  details = FALSE, ...)

\method{plot}{blr_step_p_both}(x, model = NA, ...)
}
\arguments{
\item{model}{An object of class \code{lm}; the model should include all
candidate predictor variables.}

\item{...}{Other arguments.}

\item{pent}{p value; variables with p value less than \code{pent} will enter
into the model.}

\item{prem}{p value; variables with p more than \code{prem} will be removed
from the model.}

\item{details}{Logical; if \code{TRUE}, will print the regression result at
each step.}

\item{x}{An object of class \code{blr_step_p_both}.}
}
\value{
\code{blr_step_p_both} returns an object of class \code{"blr_step_p_both"}.
An object of class \code{"blr_step_p_both"} is a list containing the
following components:

\item{orders}{candidate predictor variables according to the order by which they were added or removed from the model}
\item{method}{addition/deletion}
\item{steps}{total number of steps}
\item{predictors}{variables retained in the model (after addition)}
\item{aic}{akaike information criteria}
\item{bic}{bayesian information criteria}
\item{dev}{deviance}
\item{indvar}{predictors}
}
\description{
Build regression model from a set of candidate predictor variables by
entering and removing predictors based on p values, in a stepwise manner
until there is no variable left to enter or remove any more.
}
\examples{
\dontrun{
# stepwise regression
model <- glm(y ~ ., data = stepwise)
blr_step_p_both(model)

# stepwise regression plot
model <- glm(y ~ ., data = stepwise)
k <- blr_step_p_both(model)
plot(k)
}

}
\references{
Chatterjee, Samprit and Hadi, Ali. Regression Analysis by Example. 5th ed. N.p.: John Wiley & Sons, 2012. Print.
}
