% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_frv.R
\name{select_frv}
\alias{select_frv}
\title{Methodology to aid choosing regularization constant}
\usage{
select_frv(
  data_matrix,
  lambda_left = 0,
  lambda_right = 10,
  step = "automatic",
  model_args = list()
)
}
\arguments{
\item{data_matrix}{Data frame or matrix containing the data set to be
segmented.}

\item{lambda_left}{Left most value of lambda. Must be non-negative.}

\item{lambda_right}{Right most value of lambda. Must be non-negative and
greater than lambda_left.}

\item{step}{Value by which lambda will be increased. Must be greater than 0,
The default is 'automatic', which consists of a penalization of
1/sqrt(log(n)), where n is the number of samples (rows).}

\item{model_args}{A list with argument values for the
\link[=fit_blockcpd]{fit_blockcpd} function. The list keys must be the
arguments names. It must \emph{not} contain the argument 'lambda' or
'data_matrix'.}
}
\value{
Returns a frv object containing the suggested values and caller
parameters.
}
\description{
Aids in the selection of the penalization constants, possibly providing an
automatic optimal value. It analyses how the number of change-points vary
with the chosen grid of penalization constant. It applied the
First Repeated Value (FRV) methodology
to select the regularization constant lambda. It is similar to the Elbow
method used in clustering, or the CROPS algorithm in change-point detection.
The values of the constant range from 'lambda_left' to
'lambda_right', increasing by 'step'. For each value, the function
\link[=fit_blockcpd]{fit_blockcpd} is run with arguments 'model_args'. An
automatic suggestion for the penalization, number of change-points and model
is given automatically. Optionally, The user can call the plot function to
the output of this method so he can use an elbow plot like graphical
inspection to select the constant value.
}
