% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_model.R
\name{compare_model}
\alias{compare_model}
\title{Compare or evaluate model performance with respect
to other model or ground truth}
\usage{
compare_model(model1, model2, ncol = NULL)
}
\arguments{
\item{model1}{The first blockcpd object or list of sorted integers
representing the change point set.}

\item{model2}{The second blockcpd object or list of sorted integers
representing the change point set.}

\item{ncol}{The number of variables which the model was fitted on. Only needs
to be passed if both arguments are change point sets instead of a blockcpd
object.}
}
\value{
Returns a list containing four metrics:
\itemize{
\item{"haus"} Hausdorff distance;
\item{"rand"} Rand index;
\item{"symdiff"} Symmetric difference;
\item{"jaccard"} Jaccard index.
}
}
\description{
Compares or evaluates model estimated change point set against
another model or ground truth. The comparison is made using common metrics
to compare clusters. The metrics provided are
\itemize{
\item "hausdorff": Hausdorff Distance metric;
\item "rand": Rand Index ;
\item "symdiff": Symmetric difference metric;
\item "jaccard": Jaccard similarity index.
}
}
\examples{
model1 = fit_blockcpd(c(0, 1, 0, 1), lambda = 0)
model2 = fit_blockcpd(c(0, 1, 0, 1), lambda = Inf)
comparison = compare_model(model1, model2)
# change-point sets can also be passed directly with ncol
compare_model(c(1,2,3,4), c(3), 10)
}
