% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_imgur_image.R
\name{add_imgur_image}
\alias{add_imgur_image}
\title{Deploy a local image to Imgur and create an image tag}
\usage{
add_imgur_image(
  image,
  client_id = NULL,
  alt = NULL,
  width = 520,
  align = c("center", "left", "right", "inline"),
  float = c("none", "left", "right")
)
}
\arguments{
\item{image}{The path to the local image we would like to deploy to Imgur and
for which we'd like an image tag.}

\item{client_id}{The Imgur Client ID value.}

\item{alt}{Text description of image passed to the \code{alt} attribute inside of
the image (\verb{<img>}) tag for use when image loading is disabled and on
screen readers. \code{NULL} default produces blank (\code{""}) alt text.}

\item{width}{The width to be used for the image, in pixels.}

\item{align}{The alignment to be used for the image. If not \code{"inline"}, the
image will appear in its own block, i.e. there will not be text to the left
or right of it.}

\item{float}{The float value to be used for the image. If not \code{"none"}, text
will flow around the image, and the \code{align} argument will be ignored.}
}
\value{
An HTML fragment that can be placed inside the message body wherever
the image should appear.
}
\description{
Getting images into email message bodies (and expecting them to appear for
the recipient) can be a harrowing experience. External images (i.e.,
available at public URLs) work exceedingly well and most email clients will
faithfully display these images. With the \code{imgur_image()} function, we can
take a local image file or a \code{ggplot2} plot object and send it to the Imgur
service, and finally receive an image (\verb{<img>}) tag that can be directly
inserted into an email message using \code{compose_email()}.
}
\details{
To take advantage of this, we need to first have an account with Imgur and
then obtain a \code{Client-ID} key for the Imgur API. This can be easily done by
going to \verb{https://api.imgur.com/oauth2/addclient} and registering an
application. Be sure to select the OAuth 2 authorization type without a
callback URL.
}
