% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_bm_pixmap.R
\name{as_bm_pixmap}
\alias{as_bm_pixmap}
\alias{as_bm_pixmap.default}
\alias{as_bm_pixmap.array}
\alias{as_bm_pixmap.bm_bitmap}
\alias{as_bm_pixmap.bm_pixmap}
\alias{as_bm_pixmap.glyph_bitmap}
\alias{as_bm_pixmap.grob}
\alias{as_bm_pixmap.magick-image}
\alias{as_bm_pixmap.matrix}
\alias{as_bm_pixmap.maze}
\alias{as_bm_pixmap.pattern_square}
\alias{as_bm_pixmap.pattern_weave}
\alias{as_bm_pixmap.pixmapGrey}
\alias{as_bm_pixmap.pixmapIndexed}
\alias{as_bm_pixmap.pixmapRGB}
\alias{as_bm_pixmap.nativeRaster}
\alias{as_bm_pixmap.pixeltrix}
\alias{as_bm_pixmap.raster}
\title{Cast to a pixmap matrix object}
\usage{
as_bm_pixmap(x, ...)

\method{as_bm_pixmap}{default}(x, ...)

\method{as_bm_pixmap}{array}(x, ...)

\method{as_bm_pixmap}{bm_bitmap}(x, ..., col = getOption("bittermelon.col", col_bitmap))

\method{as_bm_pixmap}{bm_pixmap}(x, ...)

\method{as_bm_pixmap}{glyph_bitmap}(x, ..., col = getOption("bittermelon.col", col_bitmap))

\method{as_bm_pixmap}{grob}(x, ..., width = 16L, height = 16L, png_device = NULL)

\method{as_bm_pixmap}{`magick-image`}(x, ...)

\method{as_bm_pixmap}{matrix}(x, ...)

\method{as_bm_pixmap}{maze}(
  x,
  ...,
  walls = FALSE,
  start = NULL,
  end = NULL,
  solve = !is.null(start) && !is.null(end),
  col = getOption("bittermelon.col", col_bitmap)
)

\method{as_bm_pixmap}{pattern_square}(x, ..., col = getOption("bittermelon.col", col_bitmap))

\method{as_bm_pixmap}{pattern_weave}(x, ..., col = getOption("bittermelon.col", col_bitmap))

\method{as_bm_pixmap}{pixmapGrey}(x, ...)

\method{as_bm_pixmap}{pixmapIndexed}(x, ...)

\method{as_bm_pixmap}{pixmapRGB}(x, ...)

\method{as_bm_pixmap}{nativeRaster}(x, ...)

\method{as_bm_pixmap}{pixeltrix}(x, ...)

\method{as_bm_pixmap}{raster}(x, ...)
}
\arguments{
\item{x}{an Object}

\item{...}{Potentially passed to other methods e.g. \code{as_bm_pixmap.default()} passes \code{...} to \code{\link[=as.raster]{as.raster()}}.}

\item{col}{Character vector of R color specifications.}

\item{width}{Desired width of bitmap}

\item{height}{Desired height of bitmap}

\item{png_device}{A function taking arguments \code{filename}, \code{width}, and \code{height}
that starts a graphics device that saves a png image
with a transparent background.  By default will use \code{\link[ragg:agg_png]{ragg::agg_png()}}
if available else the \dQuote{cairo} version of \code{\link[grDevices:png]{grDevices::png()}}
if available else just \code{\link[grDevices:png]{grDevices::png()}}.}

\item{walls}{If \code{TRUE} the values of 1L denote the walls and the values of 0L denote the paths.}

\item{start, end}{If not \code{NULL} mark the \code{start} and \code{end} as value 2L.
See \code{\link[mazing:find_maze_refpoint]{mazing::find_maze_refpoint()}}.}

\item{solve}{If \code{TRUE} then mark the solution path from \code{start} to \code{end} as value 3L.
See \code{\link[mazing:solve_maze]{mazing::solve_maze()}}.}
}
\value{
A \code{\link[=bm_pixmap]{bm_pixmap()}} object.
}
\description{
\code{as_bm_pixmap()} casts an object to a \verb{[bm_pixmap()]} object.
}
\examples{
crops <- farming_crops_16x16()
corn <- crops$corn$portrait
is_bm_pixmap(corn)
all.equal(corn, as_bm_pixmap(as.array(corn)))
all.equal(corn, as_bm_pixmap(as.raster(corn)))
if (requireNamespace("farver", quietly = TRUE)) {
  all.equal(corn, as_bm_pixmap(as.raster(corn, native = TRUE)))
}
if (requireNamespace("magick", quietly = TRUE)) {
  all.equal(corn, as_bm_pixmap(magick::image_read(corn)))
}

if (requireNamespace("mazing", quietly = TRUE) &&
    cli::is_utf8_output() &&
    cli::num_ansi_colors() >= 8L) {
  pal <- grDevices::palette.colors()
  pm <- as_bm_pixmap(mazing::maze(24L, 32L),
                     start = "top", end = "bottom",
                     col = c(pal[6], "white", pal[7], pal[5]))
  pm <- bm_pad(pm, sides = 1L)
  print(pm, compress = "v", bg = "white")
}
if (requireNamespace("gridpattern", quietly = TRUE) &&
    cli::is_utf8_output() &&
    cli::num_ansi_colors() >= 256L) {
  s <- gridpattern::pattern_square(subtype = 8L, nrow = 8L, ncol = 50L)
  pm <- as_bm_pixmap(s, col = grDevices::rainbow(8L))
  print(pm, compress = "vertical")
}
}
\seealso{
\code{\link[=bm_pixmap]{bm_pixmap()}}, \code{\link[=is_bm_pixmap]{is_bm_pixmap()}}
}
