% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mcmc_bite.R
\encoding{UTF-8}
\name{plot_mcmc_bite}
\alias{plot_mcmc_bite}
\title{Plot trace and density from a log file}
\usage{
plot_mcmc_bite(mcmc.log, type = c("trace", "density"), burnin = 0,
  variable = NA, label = NA, col = "#000000", cex.est = 1,
  bty = "n", kp.burn = FALSE, ...)
}
\arguments{
\item{mcmc.log}{Any mcmc sample with the saved iterations in rows and the variables in columns}

\item{type}{Character taken in c("trace", "density"). If both are specified, they are plotted side by side in the same graphical device}

\item{burnin}{The size of the burnin in number of iterations or the proportion of iteration you want to remove}

\item{variable}{The name or number of the variable to plot. If is.na(variable), all columns of mcmc.log will be plotted except "iter" and "temperature"}

\item{label}{Full variable name to be plotted}

\item{col, bty, ...}{Other graphical parameters to parse to \code{\link[graphics]{par}}}

\item{cex.est}{The magnification to be used for estimates display}

\item{kp.burn}{Logical specifying whether the plot window should adjust to the pre-burnin values (only evaluated if "trace" in type)}
}
\description{
This function plots the trace and/or density of each mcmc sample.
}
\examples{

 ## Load test data
 data(Anolis_traits)
 data(Anolis_tree)
 data(Anolis_map)
 
 ## Run a simple MCMC chain
 my.jive <- make_jive(Anolis_tree, Anolis_traits[-3],  model.priors = list(mean="BM", logvar="OU"))
 bite_ex <- tempdir()
 logfile <- sprintf("\%s/my.jive_mcmc.log", bite_ex)
 mcmc_bite(my.jive, log.file=logfile, sampling.freq=10, print.freq=10, ngen=1000) 

 ## import the results in R
 res <- read.csv(logfile, header = TRUE, sep = "\\t")
 
 ## plot the results
 plot_mcmc_bite(res, burnin = 0.2, variable = NA, cex.est = .7)
 plot_mcmc_bite(res, burnin = 0.2, variable = "prior.mean", cex.est = .7)
}
\author{
Theo Gaboriau
}
