% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bi_scale_fill.R
\name{bi_scale_fill}
\alias{bi_scale_fill}
\title{Apply Bivariate Fill to ggplot Object}
\usage{
bi_scale_fill(pal, dim = 3, flip_axes = FALSE, rotate_pal = FALSE, ...)
}
\arguments{
\item{pal}{A palette name or a vector containing a custom palette. See
the help file for \code{bi_pal} for complete list of built-in palette
names. If you are providing a custom palette, it must follow the formatting
described in the 'Advanced Options' vignette.}

\item{dim}{The dimensions of the palette, either \code{2} for a
two-by-two palette, \code{3} for a three-by-three palette, or \code{4}
for a four-by-four palette.}

\item{flip_axes}{A logical scalar; if \code{TRUE} the axes of the palette
will be flipped. If \code{FALSE} (default), the palette will be displayed
on its original axes.}

\item{rotate_pal}{A logical scalar; if \code{TRUE} the palette will be
rotated 180 degrees. If \code{FALSE} (default), the palette will be
displayed in its original orientation}

\item{...}{Arguments to pass to \code{\link{scale_fill_manual}}}
}
\value{
A \code{ggplot} object with the given bivariate palette applied to the data.
}
\description{
Applies the selected palette as the fill aesthetic when \code{\link{geom_sf}}
    is used and the \code{bi_class} variable is given as the \code{fill} in the aesthetic
    mapping.
}
\examples{
# load dependencies
library(ggplot2)

# add breaks, 3x3
data <- bi_class(stl_race_income, x = pctWhite, y = medInc, style = "quantile", dim = 3)

# create map
plot <- ggplot() +
  geom_sf(data = data, aes(fill = bi_class), color = "white", size = 0.1, show.legend = FALSE) +
  bi_scale_fill(pal = "GrPink", dim = 3)

}
\seealso{
bi_pal
}
