% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/birp_data.R
\name{simulate_birp}
\alias{simulate_birp}
\title{Simulate Data for BIRP Models
Generates simulated count data using the BIRP model framework with user-defined parameters.}
\usage{
simulate_birp(
  timepoints = c(1, 2, 3),
  timesOfChange = c(),
  gamma = NULL,
  negativeBinomial = FALSE,
  stochastic = FALSE,
  numLocations = 2,
  numMethods = 1,
  numCIGroups = 1,
  numCovariatesEffort = 1,
  numCovariatesDetection = 0,
  BACI = NULL,
  n_bar = 1000,
  N_0 = NULL,
  a = NULL,
  logSigma = NULL,
  logPhi = NULL,
  covariatesEffort = "gamma(1, 2)",
  covariatesDetection = "normal(0, 1)",
  proportionZeroEffort = 0,
  verbose = TRUE
)
}
\arguments{
\item{timepoints}{Integer vector specifying time points.}

\item{timesOfChange}{Integer vector indicating time points at which change in growth rate (gamma) occurs.}

\item{gamma}{Numeric vector denoting the values of gamma to simulate. If NULL, all gamma will be set to zero}

\item{negativeBinomial}{Logical; if \code{TRUE}, use negative binomial instead of Poisson.}

\item{stochastic}{Logical; if \code{TRUE}, simulate abundance as a stochastic process instead of deterministic.}

\item{numLocations}{Integer; number of spatial locations.}

\item{numMethods}{Integer; number of sampling methods.}

\item{numCIGroups}{Integer; number of control–intervention groups.}

\item{numCovariatesEffort}{Integer; number of effort covariates.}

\item{numCovariatesDetection}{Integer; number of detection covariates.}

\item{BACI}{Optional matrix specifying BACI design (see Details).}

\item{n_bar}{Expected average total observations per time point (across all locations).}

\item{N_0}{Optional numeric; initial abundance. If NULL, n_bar will be used instead}

\item{a}{A numeric value or vector; detection parameter(s) for the negative binomial distribution. Can be a single value (shared across methods) or a vector of values (one per method).}

\item{logSigma}{Optional numeric; log standard deviation of abundance process in the stochastic model. If NULL, logSigma will be set to -1}

\item{logPhi}{Optional numeric; log standard deviation of detection process in the stochastic model. If NULL, logPhi will be simulated according to the model assumptions}

\item{covariatesEffort}{Specifies how effort is calculated for covariates. Accepts: (1) a single number used for all covariates and locations; (2) a numeric vector with one value per covariate (applied to all locations); (3) a distribution string to simulate effort from, e.g., "gamma(a, b)" or "uniform(a, b)"; or (4) a vector of such distribution strings, one per covariate.}

\item{covariatesDetection}{Specifies how detection probabilities are calculated for covariates. Accepts: (1) a single number for all covariates and locations; (2) a numeric vector with one value per covariate (applied to all locations); (3) a distribution string, e.g., "normal(a, b)" or "uniform(a, b)"; or (4) a vector of such distribution strings, one per covariate.}

\item{proportionZeroEffort}{Proportion of time–location–method combinations with zero effort (0 to 1).}

\item{verbose}{Logical; if \code{TRUE}, print progress messages.}
}
\value{
An object of type \link{birp_data} containing the simulated dataset.
}
\description{
Simulate Data for BIRP Models
Generates simulated count data using the BIRP model framework with user-defined parameters.
}
\details{
The `BACI` matrix defines a Before-After Control-Impact experimental design. It must be a binary matrix with two columns and one row per observation.  
- The first column indicates the time period (`0 = before`, `1 = after`).  
- The second column indicates the treatment type (`0 = control`, `1 = impact`).  
This allows modeling interactions between time and treatment to isolate impact effects.
}
\examples{
data <- simulate_birp()
}
