% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CA.R
\name{CA.biplot}
\alias{CA.biplot}
\title{CA biplot}
\usage{
\method{CA}{biplot}(
  bp,
  dim.biplot = c(2, 1, 3),
  e.vects = 1:ncol(bp$X),
  variant = "Princ",
  lambda.scal = FALSE
)
}
\arguments{
\item{bp}{object of class \code{biplot} obtained from preceding function \code{biplot(center = FALSE)}. In order to maintain the frequency table, the input should not be centered or scaled. For \code{CA}, \code{bp} should be a contingency table.}

\item{dim.biplot}{dimension of the biplot. Only values 1, 2 and 3 are accepted, with default \code{2}.}

\item{e.vects}{which eigenvectors (canonical variates) to extract, with default \code{1:dim.biplot}.}

\item{variant}{which correspondence analysis variant, with default "Princ", presents a biplot with rows in principal coordinates
and columns in standard coordinates. \code{variant = "Stand"}, presents a biplot with rows in standard coordinates and columns in
principal coordinates. \code{variant = "symmetric"}, presents a symmetric biplot with row and column standard coordinates scaled
equally by the singular values.}

\item{lambda.scal}{logical value to request lambda-scaling, default is \code{FALSE}.}
}
\value{
an object of class CA, inherits from class biplot.
}
\description{
Performs calculations for a CA biplot.
}
\examples{
biplot(HairEyeColor[,,2], center = FALSE) |> CA() |> plot()

}
