% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcs.R
\name{CVA.biplot}
\alias{CVA.biplot}
\title{CVA biplot}
\usage{
\method{CVA}{biplot}(
  bp,
  dim.biplot = c(2, 1, 3),
  e.vects = 1:ncol(bp$X),
  group.aes = bp$group.aes,
  weightedCVA = "weighted",
  ...
)
}
\arguments{
\item{bp}{object of class \code{biplot} obtained from preceding function \code{biplot()}.}

\item{dim.biplot}{dimension of the biplot. Only values 1, 2 and 3 are accepted, with default \code{2}.}

\item{e.vects}{which eigenvectors (canonical variates) to extract, with default \code{1:dim.biplot}.}

\item{group.aes}{vector of the same length as the number of rows in the data matrix
for differentiated aesthetics for samples.}

\item{weightedCVA}{the default is "weighted", specifying a weighted CVA to be performed. Other possible values are "unweightedI" and "unweightedCent".}

\item{...}{additional arguments}
}
\value{
an object of class CVA, inherits from class biplot.
}
\description{
Performs calculations for a CVA biplot.
}
\examples{
biplot(iris[,1:4],iris[,5]) |> CVA()

}
