% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_SAC.R
\name{plot_SAC}
\alias{plot_SAC}
\title{Plotting lists of species accumulation curves}
\usage{
plot_SAC(SAC_selected_sites, col_mean = "blue", col_CI = "lightblue",
         alpha_mean = 0.7, alpha_CI = 0.2, xlab = "Number of sites",
         ylab = "Species", line_for_multiple = TRUE, main = NULL, ...)
}
\arguments{
\item{SAC_selected_sites}{nested list of "\code{specaccum}" objects obtained
with function \code{\link{selected_sites_SAC}}.}

\item{col_mean}{(character) color for mean value of curve. Default = "blue".}

\item{col_CI}{(character) color for confidence interval region for the curve.
Default = "lightblue".}

\item{alpha_mean}{(numeric) alpha level for line representing the mean,
values from 0 to 1. Default = 0.7. Values close to 0 increase transparency.}

\item{alpha_CI}{(numeric) alpha level for the region representing the
confidence interval. Default = 0.2.}

\item{xlab}{(character) label for x-axis of plot. Default = "Number of
sites".}

\item{ylab}{(character) label for y-axis of plot. Default = "Species".}

\item{line_for_multiple}{(logical) whether to plot SACs only as lines when
multiple objects are in one or more of the internal lists in
\code{SAC_selected_sites}. Default = TRUE.}

\item{main}{(character) title or titles for plots. The default, NULL, adds
titles according to names of elements in \code{SAC_selected_sites}.}

\item{...}{other arguments to be passed to plot method for objects of class
"\code{specaccum}".}
}
\value{
A plot of "\code{specaccum}" objects. Multiple panels will be plotted
if \code{SAC_selected_sites} list contains more than one element.
}
\description{
Creates species accumulation curve plots (one or multiple
panels) from information contained in lists obtained with the function
\code{\link{selected_sites_SAC}}.
}
\examples{
# Data
data("b_pam", package = "biosurvey")
data("m_selection", package = "biosurvey")

# Subsetting base PAM according to selections
sub_pam_all <- subset_PAM(b_pam, m_selection, selection_type = "all")

SACs <- selected_sites_SAC(PAM_subset = sub_pam_all, selection_type = "all")

# Plotting
plot_SAC(SACs)
}
