% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_PAM_geo.R
\name{plot_PAM_geo}
\alias{plot_PAM_geo}
\title{Plot of PAM indices in geography}
\usage{
plot_PAM_geo(PAM, index = "RI", master_selection = NULL,
             region_border = TRUE, mask_border = FALSE,
             selection_type = NULL, selection_number = 1,
             col_pal = NULL, border = NULL, col_sites = NULL,
             col_pre = NULL, pch_sites = 16, pch_pre = 16)
}
\arguments{
\item{PAM}{object of class base_PAM.}

\item{index}{(character) code for the index to be plotted. Options are: "RI"
(Richness), "RIN" (Richness normalized), "DF" (Dispersion field), or "MCC"
(Mean composition covariance). Default = "RI".}

\item{master_selection}{master_selection object derived from functions
\code{\link{random_selection}}, \code{\link{uniformG_selection}},
\code{\link{uniformE_selection}}, or \code{\link{EG_selection}}.}

\item{region_border}{(logical) whether to add region border to the plot.
Default = TRUE.}

\item{mask_border}{(logical) whether to add mask border to the plot. Ignored
if mask is not present in \code{master_selection}. Default = FALSE.}

\item{selection_type}{(character) Type of selection depending on the function
used to select sites. The options available are "random"
(\code{\link{random_selection}}), "G" (\code{\link{uniformG_selection}}),
"E" (\code{\link{uniformE_selection}}), and "EG" (\code{\link{EG_selection}}).}

\item{selection_number}{(numeric) number of selection to be plotted.
Default = 1.}

\item{col_pal}{color palette function to be used in defining colors for the
\code{index} to be plotted. The default, NULL, uses a simple color blind
friendly palette similar to viridis, \code{\link{purplow}}. Warmer colors
indicate higher values.}

\item{border}{color for cell borders of the PAM grid. The default, NULL, does
not plot any border.}

\item{col_sites}{color for selected sites. The default, NULL, uses
a red color to represent selected sites.}

\item{col_pre}{color for preselected sites. The default, NULL, uses
a purple color to represent preselected sites. Ignored if preselected sites
are not present in \code{master_selection}.}

\item{pch_sites}{(numeric) integer specifying a symbol when plotting points
of selected sites. Default = 16.}

\item{pch_pre}{(numeric) integer specifying a symbol when plotting points
of preselected sites. Default = 16. Ignored if preselected sites are
not present in \code{master_selection}.}
}
\value{
A plot of \code{index} represented in geography. Selected sites are added if
\code{master_selection} is defined.
}
\description{
Plot of PAM indices in geography
}
\examples{
# Data
data("b_pam", package = "biosurvey")

# Plotting
plot_PAM_geo(b_pam, index = "RI")

# You can add a legend with
legend_bar(position = "bottomleft", col = purplow(8), title = "Richness",
           labels = c("Low", "High"))
}
