% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/make_predictions.R
\name{predict_inactivation}
\alias{predict_inactivation}
\title{Prediction of Dynamic Microbial Inactivation}
\usage{
predict_inactivation(simulation_model, times, parms, temp_profile)
}
\arguments{
\item{simulation_model}{character identifying the model to be used.}

\item{times}{numeric vector of output times.}

\item{parms}{list of parameters defining the parameters of the model.}

\item{temp_profile}{data frame with discrete values of the temperature for
       each time.}
}
\value{
A list of class \code{SimulInactivation} with the results. It has
        the following entries:
        \itemize{
          \item model: character defining the model use for the prediction.
          \item model_parameters: named numeric vector with the values of
                                  the model parameters used.
          \item temp_approximation: function used for the interpolation of
                                    the temperature. For a numeric value of
                                    time given, returns the value of the
                                    temperature.
          \item simulation: A data frame with the results calculated. It
                            includes 4 columns: time, logN, N, logS and S.
          }
}
\description{
Predicts the inactivation of a microorganism for dynamic temperature
conditions. The characteristics of the microorganism are defined by
the model parameters defined.
}
\details{
The value of the temperature is calculated at each value of time by
linear interpolation of the values provided by the input argument
\code{temp_profile}.
The function \code{\link{ode}} of the package \code{\link{deSolve}} is
used for the resolution of the differential equation.
}
\examples{
## EXAMPLE 1 -----------

## Retrieve the model keys available for dynamic models.
get_model_data()

## Set the input arguments
example_model <- "Geeraerd"  # Geeraerd's model will be used
times <- seq(0, 5, length=100)  # values of time for output

model_data <- get_model_data(example_model)  # Retrive the data of the model used
print(model_data$parameters)
print(model_data$variables)
model_parms <- c(D_R = 1,
                 z = 10,
                 N_min = 100,
                 temp_ref = 100,
                 N0 = 100000,
                 C_c0 = 1000
                 )

## Define the temperature profile for the prediction
temperature_profile <- data.frame(time = c(0, 1.25, 2.25, 4.6),
                                  temperature = c(70, 105, 105, 70))

## Call the prediction function
prediction_results <- predict_inactivation(example_model, times,
                                           model_parms, temperature_profile)

## Show the results
head(prediction_results$simulation)
plot(prediction_results)

## END EXAMPLE 1 -----------
}
\seealso{
\code{\link{ode}}
}

