% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq2matrix.R
\name{list2matrix}
\alias{list2matrix}
\title{Convert list of sequences to matrix}
\usage{
list2matrix(seq_list)
}
\arguments{
\item{seq_list}{list of sequences (e.g. as returned by 
the \code{\link[seqinr]{read.fasta}} function).}
}
\value{
A matrix with the number of rows equal to the number of sequences and the 
number of columns equal to the length of the longest sequence.
}
\description{
Converts list of sequences to matrix.
}
\note{
Since matrix must have specified number of columns, ends of shorter sequences are 
completed with NAs.
}
\examples{
list2matrix(list(s1 = c("c", "g", "g", "t"),
                 s2 = c("g", "t", "c", "t", "t", "g"),
                 s3 = c("a", "a", "t")))
}
\keyword{manip}

