% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_param.R
\name{get_param}
\alias{get_param}
\title{Get a parameter (\code{param}) from a scan (\code{scan})}
\usage{
get_param(x, param)
}
\arguments{
\item{x}{A \code{scan} object.}

\item{param}{Character. A scan parameter, such as \code{DBZH} or \code{VRADH}. See
\code{\link[=summary.param]{summary.param()}} for commonly available parameters.}
}
\value{
A \code{param} object.
}
\description{
Returns the selected parameter (\code{param}) from a scan (\code{scan}).
}
\examples{
# Get summary info for a scan (including parameters)
example_scan

# Extract the VRADH scan parameter
param <- get_param(example_scan, "VRADH")

# Get summary info for this parameter
param
}
\seealso{
\itemize{
\item \code{\link[=summary.param]{summary.param()}}
}
}
