% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_scan.R
\name{get_scan}
\alias{get_scan}
\title{Get a scan (\code{scan}) from a polar volume (\code{pvol})}
\usage{
get_scan(x, elev)
}
\arguments{
\item{x}{A \code{pvol} object.}

\item{elev}{Numeric. Elevation angle.}
}
\value{
A \code{scan} object.
}
\description{
Returns the scan (\code{scan}) from a polar volume (\code{pvol}) with elevation angle
closest to \code{elev}.
}
\examples{
# Locate and read the polar volume example file
pvolfile <- system.file("extdata", "volume.h5", package = "bioRad")
pvol <- read_pvolfile(pvolfile)

# Get elevation angles
get_elevation_angles(pvol)

# Extract the scan closest to 3 degrees elevation (= 2.5)
scan <- get_scan(pvol, 3)

# Get summary info
scan
}
\seealso{
\itemize{
\item \code{\link[=summary.scan]{summary.scan()}}
\item \code{\link[=get_elevation_angles]{get_elevation_angles()}}
}
}
