% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binsregtest.R
\name{binsregtest}
\alias{binsregtest}
\title{Data-driven Nonparametric Shape Restriction and Parametric Model Specification Testing using Binscatter}
\usage{
binsregtest(y, x, w = NULL, deriv = 0, testmodel = c(3, 3),
  testmodelparfit = NULL, testmodelpoly = NULL, testshape = c(3, 3),
  testshapel = NULL, testshaper = NULL, testshape2 = NULL,
  bins = c(0, 0), nbins = NULL, binspos = "qs", binsmethod = "dpi",
  nbinsrot = NULL, nsims = 500, simsgrid = 20, simsseed = 666,
  vce = "HC1", cluster = NULL, dfcheck = c(20, 30),
  masspoints = "on", weights = NULL, subset = NULL, numdist = NULL,
  numclust = NULL)
}
\arguments{
\item{y}{outcome variable. A vector.}

\item{x}{independent variable of interest. A vector.}

\item{w}{control variables. A matrix or a vector.}

\item{deriv}{derivative order of the regression function for estimation, testing and plotting.
The default is \code{deriv=0}, which corresponds to the function itself.}

\item{testmodel}{a vector. \code{testmodel=c(p,s)} sets a piecewise polynomial of degree \code{p} with \code{s}
smoothness constraints for parametric model specification testing.  The default is
\code{testmodel=c(3,3)}, which corresponds to a cubic B-spline estimate of the regression
function of interest for testing against the fitting from a parametric model specification.}

\item{testmodelparfit}{a data frame or matrix which contains the evaluation grid and fitted values of the model(s) to be
tested against.  The column contains a series of evaluation points
at which the binscatter model and the parametric model of interest are compared with
each other.  Each parametric model is represented by other columns, which must
contain the fitted values at the corresponding evaluation points.}

\item{testmodelpoly}{degree of a global polynomial model to be tested against.}

\item{testshape}{a vector. \code{testshape=c(p,s)} sets a piecewise polynomial of degree \code{p} with \code{s}
smoothness constraints for nonparametric shape restriction testing. The default is
\code{testshape=c(3,3)}, which corresponds to a cubic B-spline estimate of the regression
function of interest for one-sided or two-sided testing.}

\item{testshapel}{a vector of null boundary values for hypothesis testing. Each number \code{a} in the vector
corresponds to one boundary of a one-sided hypothesis test to the left of the form
\code{H0: sup_x mu(x)<=a}.}

\item{testshaper}{a vector of null boundary values for hypothesis testing. Each number \code{a} in the vector
corresponds to one boundary of a one-sided hypothesis test to the right of the form
\code{H0: inf_x mu(x)>=a}.}

\item{testshape2}{a vector of null boundary values for hypothesis testing. Each number \code{a} in the vector
corresponds to one boundary of a two-sided hypothesis test ofthe form
\code{H0: sup_x |mu(x)-a|=0}.}

\item{bins}{Degree and smoothness for bin selection.}

\item{nbins}{number of bins for partitioning/binning of \code{x}.  If not specified, the number of bins is
selected via the companion function \code{binsregselect} in a data-driven, optimal way whenever possible.}

\item{binspos}{position of binning knots. The default is \code{binspos="qs"}, which corresponds to quantile-spaced
binning (canonical binscatter).  The other options are \code{"es"} for evenly-spaced binning, or
a vector for manual specification of the positions of inner knots (which must be within the range of
\code{x}).}

\item{binsmethod}{method for data-driven selection of the number of bins. The default is \code{binsmethod="dpi"},
which corresponds to the IMSE-optimal direct plug-in rule.  The other option is: \code{"rot"}
for rule of thumb implementation.}

\item{nbinsrot}{initial number of bins value used to construct the DPI number of bins selector.
If not specified, the data-driven ROT selector is used instead.}

\item{nsims}{number of random draws for constructing confidence bands and hypothesis testing. The default is
\code{nsims=500}, which corresponds to 500 draws from a standard Gaussian random vector of size
\code{[(p+1)*J - (J-1)*s]}.}

\item{simsgrid}{number of evaluation points of an evenly-spaced grid within each bin used for evaluation of
the supremum (or infimum) operation needed to construct confidence bands and hypothesis testing
procedures. The default is \code{simsgrid=20}, which corresponds to 20 evenly-spaced
evaluation points within each bin for approximating the supremum (or infimum) operator.}

\item{simsseed}{seed for simulation.}

\item{vce}{Procedure to compute the variance-covariance matrix estimator. Options are
\itemize{
\item \code{"const"} homoskedastic variance estimator.
\item \code{"HC0"} heteroskedasticity-robust plug-in residuals variance estimator
                   without weights.
\item \code{"HC1"} heteroskedasticity-robust plug-in residuals variance estimator
                   with hc1 weights. Default.
\item \code{"HC2"} heteroskedasticity-robust plug-in residuals variance estimator
                   with hc2 weights.
\item \code{"HC3"} heteroskedasticity-robust plug-in residuals variance estimator
                   with hc3 weights.
}}

\item{cluster}{cluster ID. Used for compute cluster-robust standard errors.}

\item{dfcheck}{adjustments for minimum effective sample size checks, which take into account number of unique
values of \code{x} (i.e., number of mass points), number of clusters, and degrees of freedom of
the different stat models considered. The default is \code{dfcheck=c(20, 30)}.
See \href{https://sites.google.com/site/nppackages/binsreg/Cattaneo-Crump-Farrell-Feng_2019_Stata.pdf}{Cattaneo, Crump, Farrell and Feng (2019b)} for more details.}

\item{masspoints}{how mass points in \code{x} are handled. Available options:
\itemize{
\item \code{"on"} all mass point and degrees of freedom checks are implemented. Default.
\item \code{"noadjust"} mass point checks and the corresponding effective sample size adjustments are omitted.
\item \code{"nolocalcheck"} within-bin mass point and degrees of freedom checks are omitted.
\item \code{"off"} "noadjust" and "nolocalcheck" are set simultaneously.
\item \code{"veryfew"} forces the function to proceed as if \code{x} has only a few number of mass points (i.e., distinct values).
                       In other words, forces the function to proceed as if the mass point and degrees of freedom checks were failed.
}}

\item{weights}{an optional vector of weights to be used in the fitting process. Should be \code{NULL} or
a numeric vector. For more details, see \code{\link{lm}}.}

\item{subset}{Optional rule specifying a subset of observations to be used.}

\item{numdist}{Number of distinct for selection. Used to speed up computation.}

\item{numclust}{Number of clusters for selection. Used to speed up computation.}
}
\value{
\item{\code{testshapeL}}{Results for \code{testshapel}, including: \code{testvalL}, null boundary values;
                                \code{stat.shapeL}, test statistics; and \code{pval.shapeL}, p-value.}
       \item{\code{testshapeR}}{Results for \code{testshaper}, including: \code{testvalR}, null boundary values;
                                \code{stat.shapeR}, test statistics; and \code{pval.shapeR}, p-value.}
       \item{\code{testshape2}}{Results for \code{testshape2}, including: \code{testval2}, null boundary values;
                                \code{stat.shape2}, test statistics; and \code{pval.shape2}, p-value.}
       \item{\code{testpoly}}{Results for \code{testmodelpoly}, including: \code{testpoly}, the degree of global polynomial;
                              \code{stat.poly}, test statistic; \code{pval.poly}, p-value.}
       \item{\code{testmodel}}{Results for \code{testmodelparfit}, including: \code{stat.model}, test statistics;
                               \code{pval.model}, p-values.}
       \item{\code{opt}}{ A list containing options passed to the function, as well as total sample size \code{n},
                          number of distinct values \code{Ndist} in \code{x}, number of clusters \code{Nclust}, and
                          number of bins \code{nbins}.}
}
\description{
\code{binsregtest} implements binscatter-based hypothesis testing procedures for parametric functional
            forms of and nonparametric shape restrictions on the regression function estimators, following the results
            in \href{https://arxiv.org/abs/1902.09608}{Cattaneo, Crump, Farrell and Feng (2019a)}.
            If the binning scheme is not set by the user,
            the companion function \code{\link{binsregselect}} is used to implement binscatter in a
            data-driven (optimal) way and inference procedures are based on robust bias correction.
            Binned scatter plots can be constructed using the companion function \code{\link{binsreg}}.
}
\examples{
 x <- runif(500); y <- sin(x)+rnorm(500)
 est <- binsregtest(y,x, testmodelpoly=1)
 summary(est)
}
\references{
Cattaneo, M. D., R. K. Crump, M. H. Farrell, and Y. Feng. 2019a: \href{https://arxiv.org/abs/1902.09608}{On Binscatter}. Working Paper.

Cattaneo, M. D., R. K. Crump, M. H. Farrell, and Y. Feng. 2019b: \href{https://arxiv.org/abs/1902.09615}{Binscatter Regressions}. Working Paper.
}
\seealso{
\code{\link{binsreg}}, \code{\link{binsregselect}}.
}
\author{
Matias D. Cattaneo, University of Michigan, Ann Arbor, MI. \email{cattaneo@umich.edu}.

Richard K. Crump, Federal Reserve Bank of New York, New York, NY. \email{richard.crump@ny.frb.org}.

Max H. Farrell, University of Chicago, Chicago, IL. \email{max.farrell@chicagobooth.edu}.

Yingjie Feng (maintainer), University of Michigan, Ann Arbor, MI. \email{yjfeng@umich.edu}.
}
